/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.estim;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.sysml.runtime.compress.BitmapEncoder;
import org.apache.sysml.runtime.compress.ReaderColumnSelection;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysml.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysml.runtime.compress.utils.DblArray;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CompressedSizeEstimatorSample
extends CompressedSizeEstimator {
    private static final double SHLOSSER_JACKKNIFE_ALPHA = 0.975;
    public static final double HAAS_AND_STOKES_ALPHA1 = 0.9;
    public static final double HAAS_AND_STOKES_ALPHA2 = 30.0;
    public static final int HAAS_AND_STOKES_UJ2A_C = 50;
    public static final boolean HAAS_AND_STOKES_UJ2A_CUT2 = true;
    public static final boolean HAAS_AND_STOKES_UJ2A_SOLVE = true;
    public static final int MAX_SOLVE_CACHE_SIZE = 65536;
    private static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimatorSample.class.getName());
    private int[] _sampleRows = null;
    private HashMap<Integer, Double> _solveCache = null;

    public CompressedSizeEstimatorSample(MatrixBlock data, int sampleSize) {
        super(data);
        this._sampleRows = CompressedSizeEstimatorSample.getSortedUniformSample(this._numRows, sampleSize);
        MatrixBlock select = new MatrixBlock(this._numRows, 1, false);
        for (int i = 0; i < sampleSize; ++i) {
            select.quickSetValue(this._sampleRows[i], 0, 1.0);
        }
        this._data = this._data.removeEmptyOperations(new MatrixBlock(), false, true, select);
        this._solveCache = new HashMap();
    }

    @Override
    public CompressedSizeInfo estimateCompressedColGroupSize(int[] colIndexes) {
        int sampleSize = this._sampleRows.length;
        int numCols = colIndexes.length;
        int[] sampleRows = this._sampleRows;
        UncompressedBitmap ubm = BitmapEncoder.extractBitmap(colIndexes, this._data);
        CompressedSizeEstimator.SizeEstimationFactors fact = this.computeSizeEstimationFactors(ubm, false);
        int totalCardinality = CompressedSizeEstimatorSample.getNumDistinctValues(ubm, this._numRows, sampleRows, this._solveCache);
        totalCardinality = Math.max(totalCardinality, fact.numVals);
        totalCardinality = Math.min(totalCardinality, this._numRows);
        int unseenVals = totalCardinality - fact.numVals;
        double C = Math.max(1.0 - (double)fact.numSingle / (double)sampleSize, (double)sampleSize / (double)this._numRows);
        int numZeros = sampleSize - fact.numOffs;
        int numNonZeros = (int)Math.ceil((double)this._numRows - (double)this._numRows / (double)sampleSize * C * (double)numZeros);
        numNonZeros = Math.max(numNonZeros, totalCardinality);
        if (totalCardinality <= 0 || unseenVals < 0 || numZeros < 0 || numNonZeros <= 0) {
            LOG.warn((Object)("Invalid estimates detected for " + Arrays.toString(colIndexes) + ": " + totalCardinality + " " + unseenVals + " " + numZeros + " " + numNonZeros));
        }
        int numUnseenSeg = (int)((double)unseenVals * Math.ceil((double)this._numRows / 65536.0 / 2.0));
        int totalNumSeg = fact.numSegs + numUnseenSeg;
        int totalNumRuns = CompressedSizeEstimatorSample.getNumRuns(ubm, sampleSize, this._numRows, sampleRows) + numUnseenSeg;
        return new CompressedSizeInfo(totalCardinality, numNonZeros, CompressedSizeEstimatorSample.getRLESize(totalCardinality, totalNumRuns, numCols), CompressedSizeEstimatorSample.getOLESize(totalCardinality, numNonZeros, totalNumSeg, numCols), CompressedSizeEstimatorSample.getDDCSize(totalCardinality, this._numRows, numCols));
    }

    @Override
    public CompressedSizeInfo estimateCompressedColGroupSize(UncompressedBitmap ubm) {
        CompressedSizeEstimator.SizeEstimationFactors fact = this.computeSizeEstimationFactors(ubm, true);
        return new CompressedSizeInfo(fact.numVals, fact.numOffs, CompressedSizeEstimatorSample.getRLESize(fact.numVals, fact.numRuns, ubm.getNumColumns()), CompressedSizeEstimatorSample.getOLESize(fact.numVals, fact.numOffs, fact.numSegs, ubm.getNumColumns()), CompressedSizeEstimatorSample.getDDCSize(fact.numVals, this._numRows, ubm.getNumColumns()));
    }

    private static int getNumDistinctValues(UncompressedBitmap ubm, int numRows, int[] sampleRows, HashMap<Integer, Double> solveCache) {
        return CompressedSizeEstimatorSample.haasAndStokes(ubm, numRows, sampleRows.length, solveCache);
    }

    private static int getNumRuns(UncompressedBitmap ubm, int sampleSize, int totalNumRows, int[] sampleRows) {
        int numVals = ubm.getNumValues();
        if (numVals == 0) {
            return 0;
        }
        double numRuns = 0.0;
        for (int vi = 0; vi < numVals; ++vi) {
            double nonOffsetProb;
            double additionalOffsets;
            int intervalSize;
            int intervalEnd;
            int[] offsets = ubm.getOffsetsList(vi).extractValues();
            int offsetsSize = ubm.getNumOffsets(vi);
            double offsetsRatio = (double)offsetsSize / (double)sampleSize;
            double avgAdditionalOffsets = offsetsRatio * (double)totalNumRows / (double)sampleSize;
            if (avgAdditionalOffsets < 1.0) {
                numRuns += (double)offsetsSize * (double)totalNumRows / (double)sampleSize;
                continue;
            }
            double prevNonOffsetProb = 1.0;
            boolean reachedSampleEnd = false;
            int intervalStart = -1;
            if (sampleRows[0] == 0) {
                intervalStart = 0;
            } else {
                intervalEnd = sampleRows[0];
                intervalSize = intervalEnd - intervalStart - 1;
                additionalOffsets = offsetsRatio * (double)intervalSize;
                numRuns += ((double)intervalSize - additionalOffsets) * additionalOffsets / (double)intervalSize;
                intervalStart = intervalEnd;
                prevNonOffsetProb = ((double)intervalSize - additionalOffsets) / (double)intervalSize;
            }
            boolean withinSepRun = false;
            boolean seenNonOffset = false;
            boolean startedWithOffset = false;
            boolean endedWithOffset = false;
            int offsetsPtrs = 0;
            for (int ix = 1; ix < sampleSize; ++ix) {
                if (offsetsPtrs < offsetsSize && offsets[offsetsPtrs] == intervalStart) {
                    startedWithOffset = true;
                    ++offsetsPtrs;
                    endedWithOffset = true;
                } else {
                    seenNonOffset = true;
                    endedWithOffset = false;
                }
                while (intervalStart + 1 == sampleRows[ix]) {
                    intervalStart = sampleRows[ix];
                    if (seenNonOffset) {
                        if (offsetsPtrs < offsetsSize && offsets[offsetsPtrs] == intervalStart) {
                            withinSepRun = true;
                            ++offsetsPtrs;
                            endedWithOffset = true;
                        } else {
                            numRuns += (double)withinSepRun;
                            withinSepRun = false;
                            endedWithOffset = false;
                        }
                    } else if (offsetsPtrs < offsetsSize && offsets[offsetsPtrs] == intervalStart) {
                        ++offsetsPtrs;
                        endedWithOffset = true;
                    } else {
                        seenNonOffset = true;
                        endedWithOffset = false;
                    }
                    if (++ix != sampleSize) continue;
                    reachedSampleEnd = true;
                    break;
                }
                if (reachedSampleEnd) break;
                intervalEnd = sampleRows[ix];
                intervalSize = intervalEnd - intervalStart - 1;
                additionalOffsets = offsetsRatio * (double)intervalSize;
                numRuns += ((double)intervalSize - additionalOffsets) * additionalOffsets / (double)intervalSize;
                nonOffsetProb = ((double)intervalSize - additionalOffsets) / (double)intervalSize;
                if (seenNonOffset) {
                    if (startedWithOffset) {
                        numRuns += prevNonOffsetProb;
                    }
                    if (endedWithOffset) {
                        numRuns += nonOffsetProb;
                    }
                } else {
                    numRuns += prevNonOffsetProb * nonOffsetProb;
                }
                prevNonOffsetProb = nonOffsetProb;
                intervalStart = intervalEnd;
                endedWithOffset = false;
                startedWithOffset = false;
                seenNonOffset = false;
                withinSepRun = false;
            }
            if (intervalStart != totalNumRows - 1) {
                intervalEnd = totalNumRows;
                intervalSize = intervalEnd - intervalStart - 1;
                additionalOffsets = offsetsRatio * (double)intervalSize;
                numRuns += ((double)intervalSize - additionalOffsets) * additionalOffsets / (double)intervalSize;
                nonOffsetProb = ((double)intervalSize - additionalOffsets) / (double)intervalSize;
            } else {
                nonOffsetProb = 1.0;
            }
            boolean bl = endedWithOffset = intervalStart == offsets[offsetsSize - 1];
            if (seenNonOffset) {
                if (startedWithOffset) {
                    numRuns += prevNonOffsetProb;
                }
                if (!endedWithOffset) continue;
                numRuns += nonOffsetProb;
                continue;
            }
            if (!endedWithOffset) continue;
            numRuns += prevNonOffsetProb * nonOffsetProb;
        }
        return (int)Math.min(Math.round(numRuns), Integer.MAX_VALUE);
    }

    private static int[] getSortedUniformSample(int range, int smplSize) {
        if (smplSize == 0) {
            return new int[0];
        }
        return UtilFunctions.getSortedSampleIndexes(range, smplSize);
    }

    private static int guaranteedErrorEstimator(int nRows, int sampleSize, ReaderColumnSelection sampleRowsReader) {
        HashMap<DblArray, Integer> valsCount = CompressedSizeEstimatorSample.getValCounts(sampleRowsReader);
        int singltonValsCount = 0;
        int otherValsCount = 0;
        for (Integer c : valsCount.values()) {
            if (c == 1) {
                ++singltonValsCount;
                continue;
            }
            ++otherValsCount;
        }
        return (int)Math.round((double)otherValsCount + (double)singltonValsCount * Math.sqrt((double)nRows / (double)sampleSize));
    }

    private static int shlosserEstimator(UncompressedBitmap ubm, int nRows, int sampleSize) {
        double q = (double)sampleSize / (double)nRows;
        double oneMinusQ = 1.0 - q;
        int numVals = ubm.getNumValues();
        int[] freqCounts = CompressedSizeEstimatorSample.getFreqCounts(ubm);
        double numerSum = 0.0;
        double denomSum = 0.0;
        int iPlusOne = 1;
        int i = 0;
        while (i < freqCounts.length) {
            numerSum += Math.pow(oneMinusQ, iPlusOne) * (double)freqCounts[i];
            denomSum += (double)iPlusOne * q * Math.pow(oneMinusQ, i) * (double)freqCounts[i];
            ++i;
            ++iPlusOne;
        }
        int estimate = (int)Math.round((double)numVals + (double)freqCounts[0] * numerSum / denomSum);
        return estimate < 1 ? 1 : estimate;
    }

    private static int smoothedJackknifeEstimator(UncompressedBitmap ubm, int nRows, int sampleSize) {
        int numVals = ubm.getNumValues();
        int[] freqCounts = CompressedSizeEstimatorSample.getFreqCounts(ubm);
        if (freqCounts.length == 0) {
            return 0;
        }
        int d = numVals;
        double f1 = freqCounts[0];
        int Nn2 = nRows * sampleSize;
        double D0 = ((double)d - f1 / (double)sampleSize) / (1.0 - (double)(nRows - sampleSize + 1) * f1 / (double)Nn2);
        double NTilde = (double)nRows / D0;
        double A = (double)nRows - NTilde;
        double B = A - (double)sampleSize + 1.0;
        double D = nRows - sampleSize + 1;
        A = Math.min(A, D - 1.0);
        D = Math.max(A + 1.0, D);
        double h = 1.0;
        for (double C = (double)nRows; A >= B || C >= D; A -= 1.0, C -= 1.0) {
            if (A >= B) {
                h *= A;
            }
            if (!(C >= D)) continue;
            h /= C;
        }
        double g = 0.0;
        double gamma = 0.0;
        for (int k = 2; k <= sampleSize + 1; ++k) {
            g += 1.0 / ((double)nRows - NTilde - (double)sampleSize + (double)k);
        }
        for (int i = 1; i <= freqCounts.length; ++i) {
            gamma += (double)(i * (i - 1) * freqCounts[i - 1]);
        }
        gamma *= (double)(nRows - 1) * D0 / (double)Nn2 / (double)(sampleSize - 1);
        double estimate = ((double)d + (double)nRows * h * g * (gamma += D0 / (double)nRows - 1.0)) / (1.0 - ((double)nRows - NTilde - (double)sampleSize + 1.0) * f1 / (double)Nn2);
        return estimate < 1.0 ? 1 : (int)Math.round(estimate);
    }

    private static int shlosserJackknifeEstimator(UncompressedBitmap ubm, int nRows, int sampleSize) {
        int numVals = ubm.getNumValues();
        CriticalValue cv = CompressedSizeEstimatorSample.computeCriticalValue(sampleSize);
        double nBar = (double)sampleSize / (double)numVals;
        double u = 0.0;
        for (int i = 0; i < numVals; ++i) {
            u += Math.pow((double)ubm.getNumOffsets(i) - nBar, 2.0);
        }
        u /= nBar;
        if (sampleSize != cv.usedSampleSize) {
            CompressedSizeEstimatorSample.computeCriticalValue(sampleSize);
        }
        if (u < cv.uniformityCriticalValue) {
            return CompressedSizeEstimatorSample.smoothedJackknifeEstimator(ubm, nRows, sampleSize);
        }
        return CompressedSizeEstimatorSample.shlosserEstimator(ubm, nRows, sampleSize);
    }

    private static CriticalValue computeCriticalValue(int sampleSize) {
        ChiSquaredDistribution chiSqr = new ChiSquaredDistribution((double)(sampleSize - 1));
        return new CriticalValue(chiSqr.inverseCumulativeProbability(0.975), sampleSize);
    }

    private static int haasAndStokes(UncompressedBitmap ubm, int nRows, int sampleSize, HashMap<Integer, Double> solveCache) {
        int numVals = ubm.getNumValues();
        int[] freqCounts = CompressedSizeEstimatorSample.getFreqCounts(ubm);
        if (numVals == 0) {
            return 1;
        }
        double q = (double)sampleSize / (double)nRows;
        double f1 = freqCounts[0];
        double duj1 = CompressedSizeEstimatorSample.getDuj1Estimate(q, f1, sampleSize, numVals);
        double gamma = CompressedSizeEstimatorSample.getGammaSquared(duj1, freqCounts, sampleSize, nRows);
        double d = -1.0;
        d = gamma < 0.9 ? CompressedSizeEstimatorSample.getDuj2Estimate(q, f1, sampleSize, numVals, gamma) : (gamma < 30.0 ? CompressedSizeEstimatorSample.getDuj2aEstimate(q, freqCounts, sampleSize, numVals, gamma, nRows, solveCache) : CompressedSizeEstimatorSample.getSh3Estimate(q, freqCounts, numVals));
        return Math.max(1, (int)Math.round(d));
    }

    private static HashMap<DblArray, Integer> getValCounts(ReaderColumnSelection sampleRowsReader) {
        HashMap<DblArray, Integer> valsCount = new HashMap<DblArray, Integer>();
        DblArray val = null;
        while (null != (val = sampleRowsReader.nextRow())) {
            Integer cnt = valsCount.get(val);
            if (cnt == null) {
                cnt = 0;
            }
            Integer n = cnt;
            Integer n2 = cnt = Integer.valueOf(cnt + 1);
            valsCount.put(new DblArray(val), cnt);
        }
        return valsCount;
    }

    private static int[] getFreqCounts(UncompressedBitmap ubm) {
        int numVals = ubm.getNumValues();
        int maxCount = 0;
        for (int i = 0; i < numVals; ++i) {
            maxCount = Math.max(maxCount, ubm.getNumOffsets(i));
        }
        int[] freqCounts = new int[maxCount];
        for (int i = 0; i < numVals; ++i) {
            int n = ubm.getNumOffsets(i) - 1;
            freqCounts[n] = freqCounts[n] + 1;
        }
        return freqCounts;
    }

    private static double getDuj1Estimate(double q, double f1, int n, int dn) {
        return (double)dn / (1.0 - (1.0 - q) * f1 / (double)n);
    }

    private static double getDuj2Estimate(double q, double f1, int n, int dn, double gammaDuj1) {
        return ((double)dn - (1.0 - q) * f1 * Math.log(1.0 - q) * gammaDuj1 / q) / (1.0 - (1.0 - q) * f1 / (double)n);
    }

    private static double getDuj2aEstimate(double q, int[] f, int n, int dn, double gammaDuj1, int N, HashMap<Integer, Double> solveCache) {
        int i;
        int c = f.length / 2 + 1;
        int nB = 0;
        int cardB = 0;
        for (int i2 = c; i2 <= f.length; ++i2) {
            if (f[i2 - 1] == 0) continue;
            nB += f[i2 - 1] * i2;
            cardB += f[i2 - 1];
        }
        if (n - nB == 0) {
            return CompressedSizeEstimatorSample.getDuj2Estimate(q, f[0], n, dn, gammaDuj1);
        }
        int updatedN = N;
        for (i = c; i <= f.length; ++i) {
            if (f[i - 1] == 0) continue;
            updatedN = (int)((double)updatedN - (double)f[i - 1] * CompressedSizeEstimatorSample.getMethodOfMomentsEstimate(i, q, 1.0, N, solveCache));
        }
        for (i = c; i <= f.length; ++i) {
            f[i - 1] = 0;
        }
        double updatedDuj1 = CompressedSizeEstimatorSample.getDuj1Estimate(q, f[0], n - nB, dn - cardB);
        double updatedGammaDuj1 = CompressedSizeEstimatorSample.getGammaSquared(updatedDuj1, f, n - nB, updatedN);
        double duj2 = CompressedSizeEstimatorSample.getDuj2Estimate(q, f[0], n - nB, dn - cardB, updatedGammaDuj1);
        return duj2 + (double)cardB;
    }

    private static double getSh3Estimate(double q, int[] f, double dn) {
        double fraq11 = 0.0;
        double fraq12 = 0.0;
        double fraq21 = 0.0;
        double fraq22 = 0.0;
        for (int i = 1; i <= f.length; ++i) {
            if (f[i - 1] == 0) continue;
            fraq11 += (double)i * q * q * Math.pow(1.0 - q * q, i - 1) * (double)f[i - 1];
            fraq12 += (Math.pow(1.0 - q * q, i) - Math.pow(1.0 - q, i)) * (double)f[i - 1];
            fraq21 += Math.pow(1.0 - q, i) * (double)f[i - 1];
            fraq22 += (double)i * q * Math.pow(1.0 - q, i - 1) * (double)f[i - 1];
        }
        return dn + (double)f[0] * fraq11 / fraq12 * Math.pow(fraq21 / fraq22, 2.0);
    }

    private static double getGammaSquared(double D, int[] f, int n, int N) {
        double gamma = 0.0;
        for (int i = 1; i <= f.length; ++i) {
            if (f[i - 1] == 0) continue;
            gamma += (double)(i * (i - 1) * f[i - 1]);
        }
        gamma *= D / (double)n / (double)n;
        return Math.max(0.0, gamma += D / (double)N - 1.0);
    }

    private static double getMethodOfMomentsEstimate(int nj, double q, double min, double max, HashMap<Integer, Double> solveCache) {
        if (solveCache.containsKey(nj)) {
            return solveCache.get(nj);
        }
        double est = UnivariateSolverUtils.solve((UnivariateFunction)new MethodOfMomentsFunction(nj, q), (double)min, (double)max, (double)1.0E-9);
        if (solveCache.size() < 65536) {
            solveCache.put(nj, est);
        }
        return est;
    }

    private static class MethodOfMomentsFunction
    implements UnivariateFunction {
        private final int _nj;
        private final double _q;

        public MethodOfMomentsFunction(int nj, double q) {
            this._nj = nj;
            this._q = q;
        }

        public double value(double x) {
            return this._q * x / (1.0 - Math.pow(1.0 - this._q, x)) - (double)this._nj;
        }
    }

    private static class CriticalValue {
        public final double uniformityCriticalValue;
        public final int usedSampleSize;

        public CriticalValue(double cv, int size) {
            this.uniformityCriticalValue = cv;
            this.usedSampleSize = size;
        }
    }
}

