/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class MMTSJ
extends Lop {
    private MMTSJType _type = null;
    private boolean _multiPass = false;
    private int _numThreads = 1;

    public MMTSJ(Lop input1, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, MMTSJType type) {
        this(input1, dt, vt, et, type, false, -1);
    }

    public MMTSJ(Lop input1, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, MMTSJType type, boolean multiPass) {
        this(input1, dt, vt, et, type, multiPass, -1);
    }

    public MMTSJ(Lop input1, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, MMTSJType type, boolean multiPass, int k) {
        super(Lop.Type.MMTSJ, dt, vt);
        this.addInput(input1);
        input1.addOutput(this);
        this._type = type;
        this._multiPass = multiPass;
        this._numThreads = k;
        if (multiPass && et != LopProperties.ExecType.SPARK) {
            throw new RuntimeException("Multipass tsmm only supported for exec type SPARK.");
        }
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = et == LopProperties.ExecType.MR;
        LopProperties.ExecLocation el = et == LopProperties.ExecType.MR ? LopProperties.ExecLocation.Map : LopProperties.ExecLocation.ControlProgram;
        this.lps.addCompatibility(JobType.GMR);
        this.lps.setProperties(this.inputs, et, el, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation = MMTSJ";
    }

    @Override
    public String getInstructions(int input_index1, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input_index1, String output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this._multiPass ? "tsmm2" : "tsmm");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        sb.append("\u00b0");
        sb.append((Object)this._type);
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public static enum MMTSJType {
        NONE,
        LEFT,
        RIGHT;


        public boolean isLeft() {
            return this == LEFT;
        }
    }
}

