/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class XpathAssertions {
    private final WebTestClient.BodyContentSpec bodySpec;
    private final XpathExpectationsHelper xpathHelper;

    XpathAssertions(WebTestClient.BodyContentSpec spec, String expression, @Nullable Map<String, String> namespaces, Object ... args) {
        this.bodySpec = spec;
        this.xpathHelper = XpathAssertions.initXpathHelper(expression, namespaces, args);
    }

    private static XpathExpectationsHelper initXpathHelper(String expression, @Nullable Map<String, String> namespaces, Object[] args) {
        try {
            return new XpathExpectationsHelper(expression, namespaces, args);
        }
        catch (XPathExpressionException ex) {
            throw new AssertionError("XML parsing error", ex);
        }
    }

    public WebTestClient.BodyContentSpec isEqualTo(String expectedValue) {
        return this.assertWith(() -> this.xpathHelper.assertString(this.getContent(), this.getCharset(), expectedValue));
    }

    public WebTestClient.BodyContentSpec isEqualTo(Double expectedValue) {
        return this.assertWith(() -> this.xpathHelper.assertNumber(this.getContent(), this.getCharset(), expectedValue));
    }

    public WebTestClient.BodyContentSpec isEqualTo(boolean expectedValue) {
        return this.assertWith(() -> this.xpathHelper.assertBoolean(this.getContent(), this.getCharset(), expectedValue));
    }

    public WebTestClient.BodyContentSpec exists() {
        return this.assertWith(() -> this.xpathHelper.exists(this.getContent(), this.getCharset()));
    }

    public WebTestClient.BodyContentSpec doesNotExist() {
        return this.assertWith(() -> this.xpathHelper.doesNotExist(this.getContent(), this.getCharset()));
    }

    public WebTestClient.BodyContentSpec nodeCount(int expectedCount) {
        return this.assertWith(() -> this.xpathHelper.assertNodeCount(this.getContent(), this.getCharset(), expectedCount));
    }

    public WebTestClient.BodyContentSpec string(Matcher<? super String> matcher) {
        return this.assertWith(() -> this.xpathHelper.assertString(this.getContent(), this.getCharset(), matcher));
    }

    public WebTestClient.BodyContentSpec number(Matcher<? super Double> matcher) {
        return this.assertWith(() -> this.xpathHelper.assertNumber(this.getContent(), this.getCharset(), matcher));
    }

    public WebTestClient.BodyContentSpec nodeCount(Matcher<? super Integer> matcher) {
        return this.assertWith(() -> this.xpathHelper.assertNodeCount(this.getContent(), this.getCharset(), matcher));
    }

    public WebTestClient.BodyContentSpec string(Consumer<String> consumer) {
        return this.assertWith(() -> {
            String value = this.xpathHelper.evaluateXpath(this.getContent(), this.getCharset(), String.class);
            consumer.accept(value);
        });
    }

    public WebTestClient.BodyContentSpec number(Consumer<Double> consumer) {
        return this.assertWith(() -> {
            Double value = this.xpathHelper.evaluateXpath(this.getContent(), this.getCharset(), Double.class);
            consumer.accept(value);
        });
    }

    public WebTestClient.BodyContentSpec nodeCount(Consumer<Integer> consumer) {
        return this.assertWith(() -> {
            Integer value = this.xpathHelper.evaluateXpath(this.getContent(), this.getCharset(), Integer.class);
            consumer.accept(value);
        });
    }

    private WebTestClient.BodyContentSpec assertWith(CheckedExceptionTask task) {
        try {
            task.run();
        }
        catch (Exception ex) {
            throw new AssertionError("XML parsing error", ex);
        }
        return this.bodySpec;
    }

    private byte[] getContent() {
        byte[] body2 = this.bodySpec.returnResult().getResponseBody();
        Assert.notNull((Object)body2, (String)"Expected body content");
        return body2;
    }

    private String getCharset() {
        return Optional.of(this.bodySpec.returnResult()).map(ExchangeResult::getResponseHeaders).map(HttpHeaders::getContentType).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8).name();
    }

    public boolean equals(@Nullable Object obj) {
        throw new AssertionError((Object)"Object#equals is disabled to avoid being used in error instead of XPathAssertions#isEqualTo(String).");
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static interface CheckedExceptionTask {
        public void run() throws Exception;
    }
}

