/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports7.export;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.web.util.WebHtmlResourceHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.StrutsException;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.views.jasperreports7.export.JasperReport7ExporterProvider;

public class JasperReport7HtmlExporterProvider
implements JasperReport7ExporterProvider<HtmlExporter> {
    private static final Logger LOG = LogManager.getLogger(JasperReport7HtmlExporterProvider.class);
    private String imageServletUrl = "/images/";

    @Inject
    public JasperReport7HtmlExporterProvider(@Inject(value="struts.jasperReport7.html.imageServletUrl", required=false) String imageServletUrl) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{imageServletUrl})) {
            LOG.debug("Using custom image servlet url: {}", (Object)imageServletUrl);
            this.imageServletUrl = imageServletUrl;
        }
    }

    @Override
    public HtmlExporter createExporter(ActionInvocation invocation, JasperPrint jasperPrint) throws StrutsException {
        LOG.debug("Creating: {} exporter with image servlet url: {}", (Object)this.getClass().getSimpleName(), (Object)this.imageServletUrl);
        HttpServletRequest request = invocation.getInvocationContext().getServletRequest();
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        response.setContentType("text/html");
        HtmlExporter exporter = new HtmlExporter();
        SimpleExporterInput input = new SimpleExporterInput(jasperPrint);
        exporter.setExporterInput((ExporterInput)input);
        try (ServletOutputStream responseStream = response.getOutputStream();){
            SimpleHtmlExporterOutput exporterOutput = new SimpleHtmlExporterOutput((OutputStream)responseStream);
            WebHtmlResourceHandler imageHandler = new WebHtmlResourceHandler(request.getContextPath() + this.imageServletUrl + "%s");
            exporterOutput.setImageHandler((HtmlResourceHandler)imageHandler);
            exporter.setExporterOutput((ExporterOutput)exporterOutput);
        }
        catch (IOException e) {
            LOG.error("Error writing HTML report output using: {}", (Object)JasperReport7HtmlExporterProvider.class.getName(), (Object)e);
            throw new StrutsException(e.getMessage(), (Throwable)e);
        }
        return exporter;
    }
}

