/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.generate;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tiles.autotag.generate.BasicTemplateGenerator;
import org.apache.tiles.autotag.generate.TemplateClassGenerator;
import org.apache.tiles.autotag.generate.TemplateGenerator;
import org.apache.tiles.autotag.generate.TemplateSuiteGenerator;

public class TemplateGeneratorBuilder {
    private List<BasicTemplateGenerator.TSGeneratorDirectoryPair> templateSuiteGenerators = new ArrayList<BasicTemplateGenerator.TSGeneratorDirectoryPair>();
    private List<BasicTemplateGenerator.TCGeneratorDirectoryPair> templateClassGenerators = new ArrayList<BasicTemplateGenerator.TCGeneratorDirectoryPair>();
    private boolean generatingResources = false;
    private boolean generatingClasses = false;
    private File classesOutputDirectory;
    private File resourcesOutputDirectory;

    private TemplateGeneratorBuilder() {
    }

    public static TemplateGeneratorBuilder createNewInstance() {
        return new TemplateGeneratorBuilder();
    }

    public TemplateGeneratorBuilder setClassesOutputDirectory(File classesOutputDirectory) {
        this.classesOutputDirectory = classesOutputDirectory;
        return this;
    }

    public TemplateGeneratorBuilder setResourcesOutputDirectory(File resourcesOutputDirectory) {
        this.resourcesOutputDirectory = resourcesOutputDirectory;
        return this;
    }

    public TemplateGeneratorBuilder addClassesTemplateSuiteGenerator(TemplateSuiteGenerator generator) {
        if (this.classesOutputDirectory == null) {
            throw new NullPointerException("Classes output directory not specified, call 'setClassesOutputDirectory' first");
        }
        this.templateSuiteGenerators.add(new BasicTemplateGenerator.TSGeneratorDirectoryPair(this.classesOutputDirectory, generator));
        this.generatingClasses = true;
        return this;
    }

    public TemplateGeneratorBuilder addClassesTemplateClassGenerator(TemplateClassGenerator generator) {
        if (this.classesOutputDirectory == null) {
            throw new NullPointerException("Classes output directory not specified, call 'setClassesOutputDirectory' first");
        }
        this.templateClassGenerators.add(new BasicTemplateGenerator.TCGeneratorDirectoryPair(this.classesOutputDirectory, generator));
        this.generatingClasses = true;
        return this;
    }

    public TemplateGeneratorBuilder addResourcesTemplateSuiteGenerator(TemplateSuiteGenerator generator) {
        if (this.resourcesOutputDirectory == null) {
            throw new NullPointerException("Resources output directory not specified, call 'setClassesOutputDirectory' first");
        }
        this.templateSuiteGenerators.add(new BasicTemplateGenerator.TSGeneratorDirectoryPair(this.resourcesOutputDirectory, generator));
        this.generatingResources = true;
        return this;
    }

    public TemplateGeneratorBuilder addResourcesTemplateClassGenerator(TemplateClassGenerator generator) {
        if (this.resourcesOutputDirectory == null) {
            throw new NullPointerException("Resources output directory not specified, call 'setClassesOutputDirectory' first");
        }
        this.templateClassGenerators.add(new BasicTemplateGenerator.TCGeneratorDirectoryPair(this.resourcesOutputDirectory, generator));
        this.generatingResources = true;
        return this;
    }

    public TemplateGenerator build() {
        return new BasicTemplateGenerator(this.templateSuiteGenerators, this.templateClassGenerators, this.generatingClasses, this.generatingResources);
    }
}

