/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.struts2.ognl.DefaultOgnlCacheFactory;
import org.apache.struts2.ognl.OgnlCache;
import org.apache.struts2.ognl.OgnlCacheFactory;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;

public class ProxyUtil {
    private static final int CACHE_MAX_SIZE = 10000;
    private static final int CACHE_INITIAL_CAPACITY = 256;
    private static final OgnlCache<Class<?>, Boolean> isProxyCache = new DefaultOgnlCacheFactory(10000, OgnlCacheFactory.CacheType.WTLFU, 256).buildOgnlCache();
    private static final OgnlCache<Member, Boolean> isProxyMemberCache = new DefaultOgnlCacheFactory(10000, OgnlCacheFactory.CacheType.WTLFU, 256).buildOgnlCache();
    private static final OgnlCache<Object, Class<?>> targetClassCache = new DefaultOgnlCacheFactory(10000, OgnlCacheFactory.CacheType.WTLFU, 256).buildOgnlCache();

    public static Class<?> ultimateTargetClass(Object candidate) {
        return targetClassCache.computeIfAbsent(candidate, k -> {
            Class<?> result = null;
            if (ProxyUtil.isSpringAopProxy(k)) {
                result = ProxyUtil.springUltimateTargetClass(k);
            } else if (ProxyUtil.isHibernateProxy(k)) {
                result = ProxyUtil.getHibernateProxyTarget(k).getClass();
            }
            if (result == null) {
                result = k.getClass();
            }
            return result;
        });
    }

    public static boolean isProxy(Object object) {
        if (object == null) {
            return false;
        }
        return isProxyCache.computeIfAbsent(object.getClass(), k -> ProxyUtil.isSpringAopProxy(object) || ProxyUtil.isHibernateProxy(object));
    }

    public static boolean isProxyMember(Member member, Object object) {
        if (!Modifier.isStatic(member.getModifiers()) && !ProxyUtil.isProxy(object)) {
            return false;
        }
        return isProxyMemberCache.computeIfAbsent(member, k -> ProxyUtil.isSpringProxyMember(member) || ProxyUtil.isHibernateProxyMember(member));
    }

    public static boolean isHibernateProxy(Object object) {
        try {
            return object != null && HibernateProxy.class.isAssignableFrom(object.getClass());
        }
        catch (LinkageError ignored) {
            return false;
        }
    }

    public static boolean isHibernateProxyMember(Member member) {
        try {
            return ProxyUtil.hasMember(HibernateProxy.class, member);
        }
        catch (LinkageError ignored) {
            return false;
        }
    }

    private static Class<?> springUltimateTargetClass(Object candidate) {
        try {
            return AopProxyUtils.ultimateTargetClass((Object)candidate);
        }
        catch (LinkageError ignored) {
            return candidate.getClass();
        }
    }

    private static boolean isSpringAopProxy(Object object) {
        try {
            return AopUtils.isAopProxy((Object)object);
        }
        catch (LinkageError ignored) {
            return false;
        }
    }

    private static boolean isSpringProxyMember(Member member) {
        try {
            if (ProxyUtil.hasMember(Advised.class, member)) {
                return true;
            }
            if (ProxyUtil.hasMember(TargetClassAware.class, member)) {
                return true;
            }
            if (ProxyUtil.hasMember(SpringProxy.class, member)) {
                return true;
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    private static boolean hasMember(Class<?> clazz, Member member) {
        if (member instanceof Method) {
            Method method = (Method)member;
            return null != MethodUtils.getMatchingMethod(clazz, (String)member.getName(), (Class[])method.getParameterTypes());
        }
        if (member instanceof Field) {
            return null != FieldUtils.getField(clazz, (String)member.getName(), (boolean)true);
        }
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            return null != ConstructorUtils.getMatchingAccessibleConstructor(clazz, (Class[])constructor.getParameterTypes());
        }
        return false;
    }

    public static Object getHibernateProxyTarget(Object object) {
        try {
            return Hibernate.unproxy((Object)object);
        }
        catch (LinkageError ignored) {
            return object;
        }
    }

    @Deprecated
    public static Member resolveTargetMember(Member proxyMember, Object target) {
        return ProxyUtil.resolveTargetMember(proxyMember, target.getClass());
    }

    public static Member resolveTargetMember(Member proxyMember, Class<?> targetClass) {
        int mod = proxyMember.getModifiers();
        if (proxyMember instanceof Method) {
            if (Modifier.isPublic(mod)) {
                return MethodUtils.getMatchingAccessibleMethod(targetClass, (String)proxyMember.getName(), (Class[])((Method)proxyMember).getParameterTypes());
            }
            return MethodUtils.getMatchingMethod(targetClass, (String)proxyMember.getName(), (Class[])((Method)proxyMember).getParameterTypes());
        }
        if (proxyMember instanceof Field) {
            return FieldUtils.getField(targetClass, (String)proxyMember.getName(), (boolean)Modifier.isPublic(mod));
        }
        if (proxyMember instanceof Constructor && Modifier.isPublic(mod)) {
            return ConstructorUtils.getMatchingAccessibleConstructor(targetClass, (Class[])((Constructor)proxyMember).getParameterTypes());
        }
        return proxyMember;
    }
}

