/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.postprocessor;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Sling Validation Post Processor", description="Allows to influence the validation behaviour when using the Sling POST servlet")
public @interface ValidationPostProcessorConfiguration {
    @AttributeDefinition(name="Disabled", description="If set to true, no POST toward the Sling POST servlet will ever be validated through Sling Validation.")
    public boolean disabled() default false;

    @AttributeDefinition(name="Enabled for path prefixes", description="If not globally disabled, a POST towards a path which starts with any of the given prefixes is automatically validated. No wildcards (*,?) supported.")
    public String[] enabledForPathPrefix();

    @AttributeDefinition(name="Consider resource super types", description="If set to false the Post Processor will not use the validation models of any of the resource super types.")
    public boolean considerResourceSuperTypes() default true;

    @AttributeDefinition(name="Fail for missing validation models", description="In case validation should be performed but no validation model could be found this is either silently ignored (false) or leads to an error (true)")
    public boolean failForMissingValidationModels() default false;
}

