/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.validation.impl.model.ValidationModelImpl;
import org.apache.sling.validation.model.ChildResource;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidationModel;

public class ValidationModelBuilder {
    @Nonnull
    private final List<ResourceProperty> resourceProperties = new ArrayList<ResourceProperty>();
    @Nonnull
    private final List<ChildResource> children = new ArrayList<ChildResource>();
    @Nonnull
    private final Collection<String> applicablePaths = new ArrayList<String>();

    @Nonnull
    public ValidationModelBuilder resourceProperty(@Nonnull ResourceProperty resourceProperty) {
        this.resourceProperties.add(resourceProperty);
        return this;
    }

    @Nonnull
    public ValidationModelBuilder resourceProperties(@Nonnull List<ResourceProperty> resourceProperties) {
        this.resourceProperties.addAll(resourceProperties);
        return this;
    }

    @Nonnull
    public ValidationModelBuilder childResource(@Nonnull ChildResource childResource) {
        this.children.add(childResource);
        return this;
    }

    @Nonnull
    public ValidationModelBuilder childResources(@Nonnull List<ChildResource> childResources) {
        this.children.addAll(childResources);
        return this;
    }

    @Nonnull
    public ValidationModelBuilder setApplicablePath(@Nonnull String applicablePath) {
        this.applicablePaths.clear();
        this.applicablePaths.add(applicablePath);
        return this;
    }

    @Nonnull
    public ValidationModelBuilder addApplicablePath(@Nonnull String applicablePath) {
        this.applicablePaths.add(applicablePath);
        return this;
    }

    @Nonnull
    public ValidationModelBuilder addApplicablePaths(@Nonnull String[] applicablePaths) {
        for (String applicablePath : applicablePaths) {
            this.applicablePaths.add(applicablePath);
        }
        return this;
    }

    @Nonnull
    public ValidationModel build(@Nonnull String validatedResourceType, @Nonnull String source) {
        return new ValidationModelImpl(this.resourceProperties, validatedResourceType, this.applicablePaths, this.children, source);
    }
}

