/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib.internal;

import org.apache.sling.xss.XSSAPI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class XSSSupport {
    @Reference
    private XSSAPI xssApi;
    private static volatile XSSAPI XSS_API;

    protected void activate() {
        XSS_API = this.xssApi;
    }

    protected void deactivate() {
        XSS_API = null;
    }

    public static String encode(String unencoded, EncodingMode mode) {
        if (XSS_API == null) {
            throw new IllegalStateException("No XSS_API field set. Is the XSSAPI service available?");
        }
        switch (mode) {
            case HTML: {
                return XSS_API.encodeForHTML(unencoded);
            }
            case HTML_ATTR: {
                return XSS_API.encodeForHTMLAttr(unencoded);
            }
            case XML: {
                return XSS_API.encodeForXML(unencoded);
            }
            case XML_ATTR: {
                return XSS_API.encodeForHTMLAttr(unencoded);
            }
            case JS: {
                return XSS_API.encodeForJSString(unencoded);
            }
        }
        return unencoded;
    }

    public static EncodingMode getEncodingMode(String modeStr) {
        return EncodingMode.valueOf(modeStr.toUpperCase());
    }

    public static enum EncodingMode {
        HTML,
        HTML_ATTR,
        XML,
        XML_ATTR,
        JS;

    }
}

