/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.helper;

import java.lang.reflect.Field;
import org.apache.sling.scripting.javascript.helper.SlingContext;
import org.apache.sling.scripting.javascript.helper.SlingRhinoDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingContextFactory
extends ContextFactory {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SlingRhinoDebugger debugger;
    private ScopeProvider scopeProvider;
    private boolean debuggerActive;
    private int languageVersion;

    public static void setup(ScopeProvider sp, int languageVersion) {
        if (!SlingContextFactory.hasExplicitGlobal()) {
            SlingContextFactory.initGlobal((ContextFactory)new SlingContextFactory(sp, Context.isValidLanguageVersion((int)languageVersion) ? languageVersion : 0));
        }
    }

    public static void teardown() {
        ContextFactory factory = SlingContextFactory.getGlobal();
        if (factory instanceof SlingContextFactory) {
            ((SlingContextFactory)factory).dispose();
        }
    }

    private SlingContextFactory(ScopeProvider sp, int languageVersion) {
        this.scopeProvider = sp;
        this.languageVersion = languageVersion;
    }

    private void dispose() {
        this.exitDebugger();
        ContextFactory newGlobal = new ContextFactory();
        this.setField(newGlobal, "hasCustomGlobal", Boolean.FALSE);
        this.setField(newGlobal, "global", newGlobal);
        this.setField(newGlobal, "sealed", Boolean.FALSE);
        this.setField(newGlobal, "listeners", null);
        this.setField(newGlobal, "disabledListening", Boolean.FALSE);
        this.setField(newGlobal, "applicationClassLoader", null);
    }

    protected Context makeContext() {
        SlingContext context = new SlingContext();
        context.setLanguageVersion(this.languageVersion);
        return context;
    }

    protected boolean hasFeature(Context cx, int featureIndex) {
        if (featureIndex == 7) {
            return true;
        }
        return super.hasFeature(cx, featureIndex);
    }

    protected void onContextCreated(Context cx) {
        super.onContextCreated(cx);
        this.initDebugger(cx);
    }

    private void initDebugger(Context cx) {
        if (this.isDebugging()) {
            try {
                if (this.debugger == null) {
                    this.debugger = new SlingRhinoDebugger(((Object)((Object)this)).getClass().getSimpleName());
                    this.debugger.setScopeProvider(this.scopeProvider);
                    this.debugger.attachTo(this);
                }
            }
            catch (Exception e) {
                this.log.warn("initDebugger: Failed setting up the Rhino debugger", (Throwable)e);
            }
        }
    }

    public void exitDebugger() {
        if (this.debugger != null) {
            this.debugger.setScopeProvider(null);
            this.debugger.detach();
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    void debuggerStopped() {
        this.debugger = null;
    }

    public void setDebugging(boolean enable) {
        this.debuggerActive = enable;
    }

    public boolean isDebugging() {
        return this.debuggerActive;
    }

    private void setField(Object instance, String fieldName, Object value) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

