/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.IOException;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.SubArchive;
import org.apache.jackrabbit.vault.packaging.impl.OsgiAwarePropertiesUtil;
import org.h2.util.CloseWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractArchive
implements Archive {
    private static final Logger log = LoggerFactory.getLogger(AbstractArchive.class);
    protected static final String PROPERTY_ENABLE_STACK_TRACES = "vault.enableStackTraces";
    protected static final boolean SHOULD_CREATE_STACK_TRACE = OsgiAwarePropertiesUtil.getBooleanProperty("vault.enableStackTraces");

    AbstractArchive() {
    }

    @Override
    public Archive.Entry getEntry(String path) throws IOException {
        String name;
        String[] segs = Text.explode(path, 47);
        Archive.Entry root = this.getRoot();
        String[] stringArray = segs;
        int n = stringArray.length;
        for (int i = 0; i < n && (root = root.getChild(name = stringArray[i])) != null; ++i) {
        }
        return root;
    }

    @Override
    public Archive.Entry getJcrRoot() throws IOException {
        return this.getRoot().getChild("jcr_root");
    }

    @Override
    public Archive getSubArchive(String rootPath, boolean asJcrRoot) throws IOException {
        Archive.Entry root = this.getEntry(rootPath);
        return root == null ? null : new SubArchive(this, root, asJcrRoot);
    }

    static boolean dumpUnclosedArchives() {
        CloseWatcher w;
        boolean foundUnclosedArchive = false;
        while ((w = CloseWatcher.pollUnclosed()) != null) {
            foundUnclosedArchive = true;
            if (SHOULD_CREATE_STACK_TRACE) {
                log.error("Detected unclosed archive, it has been opened here:\n{}", (Object)w.getOpenStackTrace());
            } else {
                log.error("Detected unclosed archive. To figure out where it has been opened set the Java System property '{}' to 'true'", (Object)PROPERTY_ENABLE_STACK_TRACES);
            }
            try {
                AutoCloseable closeable = w.getCloseable();
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                log.error("Error forcing closing archive", (Throwable)e);
            }
        }
        return foundUnclosedArchive;
    }
}

