/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.hapi.HApiProperty;
import org.apache.sling.hapi.HApiType;
import org.apache.sling.hapi.HApiTypesCollection;
import org.apache.sling.hapi.HApiUtil;
import org.apache.sling.hapi.MicrodataAttributeHelper;
import org.apache.sling.hapi.impl.AbstractHapiTypeImpl;
import org.apache.sling.hapi.impl.EmptyAttributeHelperImpl;
import org.apache.sling.hapi.impl.HApiPropertyImpl;
import org.apache.sling.hapi.impl.HApiTypeImpl;
import org.apache.sling.hapi.impl.HApiTypeLazyWrapper;
import org.apache.sling.hapi.impl.HApiTypesCollectionImpl;
import org.apache.sling.hapi.impl.MicrodataAttributeHelperImpl;
import org.apache.sling.hapi.impl.TypesCache;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="Apache Sling Hypermedia API tools", service={HApiUtil.class}, configurationPid="org.apache.sling.hapi.impl.HApiUtilImpl")
@Designate(ocd=Configuration.class)
public class HApiUtilImpl
implements HApiUtil {
    private final Logger LOG = LoggerFactory.getLogger(HApiUtil.class);
    private static String resourceType;
    private String collectionResourceType;
    private static String[] hApiPaths;
    private static String serverContextPath;
    private boolean enabled;

    @Activate
    private void activate(Configuration configuration) {
        this.enabled = configuration.org_apache_sling_hapi_tools_enabled();
        if (!this.enabled) {
            return;
        }
        resourceType = configuration.org_apache_sling_hapi_tools_resourcetype();
        this.collectionResourceType = configuration.org_apache_sling_hapi_tools_collectionresourcetype();
        hApiPaths = configuration.org_apache_sling_hapi_tools_searchpaths();
        serverContextPath = configuration.org_apache_sling_hapi_tools_externalurl();
    }

    @Override
    @Deprecated
    public Node getTypeNode(ResourceResolver resolver, String type) throws RepositoryException {
        if (!this.enabled) {
            return null;
        }
        return (Node)this.getTypeResource(resolver, type).adaptTo(Node.class);
    }

    @Override
    public Resource getTypeResource(ResourceResolver resolver, String type) {
        if (!this.enabled) {
            return null;
        }
        return this.getFqdnResource(resolver, type, resourceType);
    }

    @Override
    public Resource getTypeCollectionResource(ResourceResolver resolver, String collection) {
        if (!this.enabled) {
            return null;
        }
        return this.getFqdnResource(resolver, collection, this.collectionResourceType);
    }

    private Resource getFqdnResource(ResourceResolver resolver, String fqdn, String resType) {
        Resource res = resolver.getResource(fqdn);
        if (null != res) {
            this.LOG.debug("res = " + res.getName() + " " + res.getPath());
            return res;
        }
        Iterator<String> iterator = new HashSet<String>(Arrays.asList(hApiPaths)).iterator();
        if (iterator.hasNext()) {
            String path = iterator.next();
            path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            return this.getTypeResourceFromFqdn(path, resolver, fqdn, resType);
        }
        return null;
    }

    private Resource getTypeResourceFromFqdn(String parentPath, ResourceResolver resolver, String fqdn, String resType) {
        if (null == fqdn) {
            return null;
        }
        Resource searchParent = resolver.getResource(parentPath);
        for (Resource tr : searchParent.getChildren()) {
            ValueMap resProps;
            if (!tr.isResourceType(resType) || !fqdn.equals((resProps = (ValueMap)tr.adaptTo(ValueMap.class)).get("fqdn", (Object)null))) continue;
            return tr;
        }
        return null;
    }

    @Override
    public HApiType fromPath(ResourceResolver resolver, String type) throws RepositoryException {
        if (!this.enabled) {
            return null;
        }
        Resource typeResource = this.getTypeResource(resolver, type);
        this.LOG.debug("typeResource=" + typeResource);
        if (null == typeResource) {
            return new AbstractHapiTypeImpl(type);
        }
        return this.fromResource(resolver, typeResource);
    }

    @Override
    @Deprecated
    public HApiType fromNode(ResourceResolver resolver, Node typeNode) throws RepositoryException {
        if (!this.enabled) {
            return null;
        }
        if (null == typeNode) {
            return null;
        }
        Resource resource = resolver.getResource(typeNode.getPath());
        return this.fromResource(resolver, resource);
    }

    @Override
    public HApiType fromResource(ResourceResolver resolver, Resource typeResource) throws RepositoryException {
        if (!this.enabled) {
            return null;
        }
        if (null == typeResource) {
            return null;
        }
        ValueMap resProps = (ValueMap)typeResource.adaptTo(ValueMap.class);
        String name = (String)resProps.get("name", (Object)null);
        String description = (String)resProps.get("description", (Object)null);
        String path = typeResource.getPath();
        String fqdn = (String)resProps.get("fqdn", (Object)null);
        Value[] parameterValues = (Value[])resProps.get("parameters", (Object)new Value[0]);
        ArrayList<String> parameters = new ArrayList<String>(parameterValues.length);
        for (Value p : Arrays.asList(parameterValues)) {
            parameters.add(p.getString());
        }
        String parentPath = (String)resProps.get("extends", (Object)null);
        HApiTypeLazyWrapper parentWeak = new HApiTypeLazyWrapper((HApiUtil)this, resolver, serverContextPath, parentPath);
        HashMap<String, HApiProperty> properties = new HashMap<String, HApiProperty>();
        for (Resource res : typeResource.getChildren()) {
            ValueMap resValueMap = (ValueMap)res.adaptTo(ValueMap.class);
            String propName = res.getName();
            String propDescription = (String)resValueMap.get("description", (Object)"");
            String typeFqdnOrPath = (String)resValueMap.get("type", (Object)null);
            Resource propTypeResource = this.getTypeResource(resolver, typeFqdnOrPath);
            HApiType propTypeWeak = null != propTypeResource ? new HApiTypeLazyWrapper((HApiUtil)this, resolver, serverContextPath, propTypeResource) : new AbstractHapiTypeImpl(typeFqdnOrPath);
            Boolean propMultiple = (Boolean)resValueMap.get("multiple", (Object)false);
            HApiPropertyImpl prop = new HApiPropertyImpl(propName, propDescription, propTypeWeak, propMultiple);
            properties.put(prop.getName(), prop);
        }
        HApiTypeImpl newType = new HApiTypeImpl(name, description, serverContextPath, path, fqdn, parameters, properties, parentWeak, false);
        TypesCache.getInstance(this).addType(newType);
        this.LOG.debug("Inserted type {} to cache: {}", (Object)newType, (Object)TypesCache.getInstance(this));
        this.LOG.debug("Created type {}", (Object)newType);
        return newType;
    }

    @Override
    public HApiTypesCollection collectionFromResource(ResourceResolver resolver, Resource collectionResource) throws RepositoryException {
        if (!this.enabled) {
            return null;
        }
        if (null == collectionResource) {
            return null;
        }
        ValueMap resProps = (ValueMap)collectionResource.adaptTo(ValueMap.class);
        String name = (String)resProps.get("name", (Object)null);
        String description = (String)resProps.get("description", (Object)null);
        String path = collectionResource.getPath();
        String fqdn = (String)resProps.get("fqdn", (Object)null);
        HApiTypesCollectionImpl collection = new HApiTypesCollectionImpl(name, description, serverContextPath, path, fqdn);
        for (Resource typeRes : collectionResource.getChildren()) {
            if (!typeRes.isResourceType(resourceType)) continue;
            this.LOG.debug("Trying to add type from resource: {} to the collection", (Object)typeRes);
            HApiType type = this.fromResource(resolver, typeRes);
            collection.add(type);
            this.LOG.debug("Added type {} to the collection.", (Object)type);
        }
        this.LOG.debug("Collection: {}", (Object)collection);
        return collection;
    }

    @Override
    public HApiTypesCollection collectionFromPath(ResourceResolver resolver, String collectionPath) throws RepositoryException {
        if (!this.enabled) {
            return null;
        }
        return this.collectionFromResource(resolver, this.getTypeCollectionResource(resolver, collectionPath));
    }

    @Override
    public MicrodataAttributeHelper getHelper(ResourceResolver resolver, String type) throws RepositoryException {
        if (!this.enabled) {
            return new EmptyAttributeHelperImpl();
        }
        return new MicrodataAttributeHelperImpl(resolver, TypesCache.getInstance(this).getType(resolver, this.getTypeResource(resolver, type)));
    }

    @ObjectClassDefinition(name="Apache Sling Hypermedia API tools")
    static @interface Configuration {
        @AttributeDefinition(name="HApi Resource Type", description="The resource used for hapi types")
        public String org_apache_sling_hapi_tools_resourcetype() default "sling/hapi/components/type";

        @AttributeDefinition(name="HApi Collection Resource Type", description="The resource used for hapi type collections")
        public String org_apache_sling_hapi_tools_collectionresourcetype() default "sling/hapi/components/typescollection";

        @AttributeDefinition(name="HApi Types Search Paths", description="The path under which children resources can be identified as hapi types by their FQDN value in addition to the type path")
        public String[] org_apache_sling_hapi_tools_searchpaths() default {"/libs/sling/hapi/types"};

        @AttributeDefinition(name="External server URL", description="The external URL of the instance. This will prefix hapi absolute URLs")
        public String org_apache_sling_hapi_tools_externalurl() default "http://localhost:8080";

        @AttributeDefinition(name="Enabled", description="Whether hapi is enabled or completely disabled (no output rendered in components)", type=AttributeType.BOOLEAN)
        public boolean org_apache_sling_hapi_tools_enabled() default true;
    }
}

