/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.ContentFileResource;
import org.apache.sling.fsprovider.internal.mapper.Escape;
import org.apache.sling.fsprovider.internal.mapper.FileNameComparator;
import org.apache.sling.fsprovider.internal.mapper.FileResource;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;

public final class ContentFileResourceMapper {
    private final String providerRootPrefix;
    private final File providerFile;
    private final ContentFileExtensions contentFileExtensions;
    private final ContentFileCache contentFileCache;
    private final FileStatCache fileStatCache;

    public ContentFileResourceMapper(String providerRoot, File providerFile, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache, FileStatCache fileStatCache) {
        this.providerRootPrefix = providerRoot.concat("/");
        this.providerFile = providerFile;
        this.contentFileExtensions = contentFileExtensions;
        this.contentFileCache = contentFileCache;
        this.fileStatCache = fileStatCache;
    }

    public Resource getResource(ResourceResolver resolver, String resourcePath) {
        ContentFile contentFile = this.getFile(resourcePath, null);
        if (contentFile != null && contentFile.hasContent()) {
            return new ContentFileResource(resolver, contentFile);
        }
        return null;
    }

    public Iterator<Resource> getChildren(final ResourceResolver resolver, Resource parent) {
        Iterator children;
        Object[] files;
        File parentDir;
        final String parentPath = parent.getPath();
        final ContentFile parentContentFile = this.getFile(parentPath, null);
        ArrayList<Iterator> childIterators = new ArrayList<Iterator>(2);
        if (parentContentFile != null && parentContentFile.hasContent()) {
            childIterators.add(IteratorUtils.transformedIterator(parentContentFile.getContent().getChildren().keySet().iterator(), (Transformer)new Transformer<String, Resource>(){

                public Resource transform(String name) {
                    return new ContentFileResource(resolver, parentContentFile.navigateToRelative(name));
                }
            }));
        }
        if (this.fileStatCache.isDirectory(parentDir = new File(this.providerFile, StringUtils.removeStart((String)parentPath, (String)this.providerRootPrefix))) && (files = parentDir.listFiles()) != null) {
            Arrays.sort(files, FileNameComparator.INSTANCE);
            childIterators.add(IteratorUtils.transformedIterator((Iterator)IteratorUtils.arrayIterator((Object[])files), (Transformer)new Transformer<File, Resource>(){

                public Resource transform(File file) {
                    String path = parentPath + "/" + Escape.fileToResourceName(file.getName());
                    String filenameSuffix = ContentFileResourceMapper.this.contentFileExtensions.getSuffix(file);
                    if (filenameSuffix != null) {
                        path = StringUtils.substringBeforeLast((String)path, (String)filenameSuffix);
                        ContentFile contentFile = new ContentFile(file, path, null, ContentFileResourceMapper.this.contentFileCache);
                        return new ContentFileResource(resolver, contentFile);
                    }
                    return new FileResource(resolver, path, file, ContentFileResourceMapper.this.contentFileExtensions, ContentFileResourceMapper.this.contentFileCache, ContentFileResourceMapper.this.fileStatCache);
                }
            }));
        }
        if (!(children = IteratorUtils.chainedIterator(childIterators)).hasNext()) {
            return null;
        }
        return children;
    }

    private ContentFile getFile(String path, String subPath) {
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)this.providerRootPrefix)) {
            return null;
        }
        String relPath = Escape.resourceToFileName(path.substring(this.providerRootPrefix.length()));
        for (String filenameSuffix : this.contentFileExtensions.getSuffixes()) {
            File file = new File(this.providerFile, relPath + filenameSuffix);
            if (!this.fileStatCache.exists(file)) continue;
            return new ContentFile(file, path, subPath, this.contentFileCache);
        }
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            return null;
        }
        String nextSubPath = path.substring(parentPath.length() + 1) + (subPath != null ? "/" + subPath : "");
        return this.getFile(parentPath, nextSubPath);
    }
}

