/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.featureflags.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.featureflags.ExecutionContext;
import org.apache.sling.featureflags.Feature;
import org.apache.sling.featureflags.Features;

public class ExecutionContextImpl
implements ExecutionContext {
    private static final String REQUEST_ATTRIBUTE_RESOLVER = "org.apache.sling.auth.core.ResourceResolver";
    private final ResourceResolver resourceResolver;
    private final HttpServletRequest request;
    private final Map<String, Boolean> featureCache;
    private final Features features;

    public ExecutionContextImpl(Features features, HttpServletRequest request) {
        ResourceResolver resourceResolver = null;
        if (request != null) {
            if (request instanceof SlingHttpServletRequest) {
                resourceResolver = ((SlingHttpServletRequest)request).getResourceResolver();
            } else {
                Object resolverObject = request.getAttribute(REQUEST_ATTRIBUTE_RESOLVER);
                if (resolverObject instanceof ResourceResolver) {
                    resourceResolver = (ResourceResolver)resolverObject;
                }
            }
        }
        this.request = request;
        this.resourceResolver = resourceResolver;
        this.featureCache = new HashMap<String, Boolean>();
        this.features = features;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    boolean isEnabled(Feature feature) {
        String name = feature.getName();
        Boolean entry = this.featureCache.get(name);
        if (entry == null) {
            this.featureCache.put(name, Boolean.FALSE);
            entry = feature.isEnabled(this);
            this.featureCache.put(name, entry);
        }
        return entry;
    }
}

