/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonGenerator;
import java.io.Serializable;

class JsonWriterImpl
implements JsonWriter,
Serializable {
    private final JsonGenerator generator;
    private boolean called = false;
    private boolean closed = false;

    JsonWriterImpl(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void writeArray(JsonArray array) {
        this.checkState();
        this.generator.write(array);
        this.markCalled();
    }

    @Override
    public void writeObject(JsonObject object) {
        this.checkState();
        this.generator.write(object);
        this.markCalled();
    }

    @Override
    public void write(JsonValue value) {
        this.checkState();
        this.generator.write(value);
        this.markCalled();
    }

    @Override
    public void write(JsonStructure value) {
        this.checkState();
        this.generator.write(value);
        this.markCalled();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.generator.close();
        }
    }

    private void markCalled() {
        this.generator.flush();
        this.called = true;
    }

    private void checkState() {
        if (this.closed || this.called) {
            throw new IllegalStateException("writeArray(), writeObject(), write() or close() method was already called");
        }
    }
}

