/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.projectsupport.AbstractLaunchpadFrameworkMojo;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="create-bundle-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class CreateBundleJarMojo
extends AbstractLaunchpadFrameworkMojo {
    @Parameter
    private Resource[] resources;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifactId}-${project.version}", required=true)
    private String jarName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    private static final String CLASSIFIER = "bundles";
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};

    private void addBundles() throws MojoExecutionException {
        BundleList bundles = this.getInitializedBundleList();
        for (StartLevel level : bundles.getStartLevels()) {
            for (Bundle bundle : level.getBundles()) {
                Artifact artifact = this.getArtifact(new ArtifactDefinition(bundle, level.getStartLevel()));
                String destFileName = this.getPathForArtifact(level.getStartLevel(), bundle.getRunModes(), artifact.getFile().getName());
                try {
                    this.jarArchiver.addFile(artifact.getFile(), destFileName);
                }
                catch (ArchiverException e) {
                    throw new MojoExecutionException("Unable to add file to bundle jar file: " + artifact.getFile().getAbsolutePath(), (Exception)((Object)e));
                }
            }
        }
    }

    private void addResources(Resource resource) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Adding resources [%s] to [%s]", resource.getDirectory(), resource.getTargetPath()));
        String[] fileNames = CreateBundleJarMojo.getFilesToCopy(resource);
        for (int i = 0; i < fileNames.length; ++i) {
            String targetFileName = fileNames[i];
            if (resource.getTargetPath() != null) {
                targetFileName = resource.getTargetPath() + File.separator + targetFileName;
            }
            try {
                this.jarArchiver.addFile(new File(resource.getDirectory(), fileNames[i]), targetFileName);
                continue;
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Unable to add resources to JAR file", (Exception)((Object)e));
            }
        }
    }

    private File createJARFile() throws MojoExecutionException {
        File jarFile = new File(this.outputDirectory, this.jarName + "-" + CLASSIFIER + "." + "jar");
        this.jarArchiver.setDestFile(jarFile);
        this.addBundles();
        this.addResources();
        try {
            this.jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to create bundle jar file", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create bundle jar file", (Exception)e);
        }
        return jarFile;
    }

    private void addResources() throws MojoExecutionException {
        if (this.resources != null) {
            for (Resource resource : this.resources) {
                if (!new File(resource.getDirectory()).isAbsolute()) {
                    resource.setDirectory(this.project.getBasedir() + File.separator + resource.getDirectory());
                }
                this.addResources(resource);
            }
        }
    }

    @Override
    protected void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        File jarFile = this.createJARFile();
        this.projectHelper.attachArtifact(this.project, "jar", CLASSIFIER, jarFile);
    }

    private static String[] getFilesToCopy(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(new String[resource.getIncludes().size()]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(new String[resource.getExcludes().size()]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

