/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.map.ValuesUnderCursor;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class ValuesFormatter
extends ValuesUnderCursor.Formatter {
    private static final char SEPARATOR = '\u2003';
    private static final int DEFAULT_FORMAT = -1;
    private static final int SCIENTIFIC_NOTATION = -2;
    private final GridCoverage.Evaluator evaluator;
    private final NumberFormat[] sampleFormats;
    private final StringBuffer buffer = new StringBuffer();
    private final FieldPosition field = new FieldPosition(0);
    private final String[] units;
    private final Map<Long, String> nodata;
    private String outsideText;
    private BitSet selectedBands;
    private GridExtent newSlice;
    private String lastErrorMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValuesFormatter(ValuesUnderCursor owner, ValuesFormatter inherit, GridCoverage coverage, GridExtent slice, List<SampleDimension> bands, Locale locale) {
        super(owner);
        this.newSlice = slice;
        this.evaluator = coverage.forConvertedValues(true).evaluator();
        this.evaluator.setNullIfOutside(true);
        this.evaluator.setWraparoundEnabled(true);
        if (inherit != null) {
            StringBuffer stringBuffer = inherit.buffer;
            synchronized (stringBuffer) {
                this.units = inherit.units;
                this.nodata = inherit.nodata;
                this.outsideText = inherit.outsideText;
                this.selectedBands = inherit.selectedBands;
                this.sampleFormats = (NumberFormat[])inherit.sampleFormats.clone();
                for (int i = 0; i < this.sampleFormats.length; ++i) {
                    this.sampleFormats[i] = (NumberFormat)this.sampleFormats[i].clone();
                }
            }
            return;
        }
        int numBands = bands.size();
        this.sampleFormats = new NumberFormat[numBands];
        this.units = new String[numBands];
        this.nodata = new HashMap<Long, String>();
        this.selectedBands = new BitSet();
        this.selectedBands.set(0, numBands <= 3 ? numBands : 1, true);
        HashMap<Integer, NumberFormat> sharedFormats = new HashMap<Integer, NumberFormat>();
        HashMap sharedSymbols = new HashMap();
        UnitFormat unitFormat = new UnitFormat(locale);
        for (int b = 0; b < numBands; ++b) {
            SampleDimension sd = bands.get(b);
            for (Category c : sd.forConvertedValues(true).getCategories()) {
                float value = ((Number)((Object)c.getSampleRange().getMinValue())).floatValue();
                if (!Float.isNaN(value)) continue;
                try {
                    this.nodata.putIfAbsent(ValuesFormatter.toNodataKey(b, value), c.getName().toString(locale));
                }
                catch (IllegalArgumentException e) {
                    this.recoverableException("changed", e);
                }
            }
            this.units[b] = sd.getUnits().map(unit -> sharedSymbols.computeIfAbsent(unit, key -> this.format(unitFormat, (Unit<?>)key))).orElse("");
            SampleDimension isd = sd.forConvertedValues(false);
            Integer nf = isd.getTransferFunctionFormula().map(formula -> ValuesFormatter.suggestFractionDigits(formula, isd)).orElse(-1);
            this.sampleFormats[b] = sharedFormats.computeIfAbsent(nf, precision -> {
                switch (precision) {
                    case 0: {
                        return NumberFormat.getIntegerInstance(locale);
                    }
                    case -1: {
                        return NumberFormat.getNumberInstance(locale);
                    }
                    case -2: {
                        NumberFormat format = NumberFormat.getNumberInstance(locale);
                        if (precision == -2 && format instanceof DecimalFormat) {
                            ((DecimalFormat)format).applyPattern("0.000E00");
                        }
                        return format;
                    }
                }
                NumberFormat format = NumberFormat.getNumberInstance(locale);
                format.setMinimumFractionDigits((int)precision);
                format.setMaximumFractionDigits((int)precision);
                return format;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(UnitFormat format, Unit<?> unit) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.setLength(0);
            format.format(unit, this.buffer, this.field);
            if (this.buffer.length() != 0 && Character.isLetterOrDigit(this.buffer.codePointAt(0))) {
                this.buffer.insert(0, '\u00a0');
            }
            return this.buffer.toString();
        }
    }

    /*
     * Exception decompiling
     */
    final String setSelectedBands(BitSet selection, String[] labels, HashSet<String> others) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIter.rewriteExpressions(StructuredIter.java:119)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final synchronized void setSlice(GridExtent slice) {
        this.newSlice = slice;
    }

    @Override
    DirectPosition copy(DirectPosition point) {
        assert (Thread.holdsLock(this));
        Position position = new Position(point, this.newSlice);
        this.newSlice = null;
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(DirectPosition point) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            block13: {
                this.buffer.setLength(0);
                if (point != null) {
                    try {
                        double[] results;
                        GridExtent slice = ((Position)point).newSlice;
                        if (slice != null) {
                            this.evaluator.setDefaultSlice((Map)slice.getSliceCoordinates());
                        }
                        if ((results = this.evaluator.apply(point)) == null) break block13;
                        BitSet selection = this.selectedBands;
                        int i = -1;
                        while ((i = selection.nextSetBit(i + 1)) >= 0) {
                            double value;
                            if (this.buffer.length() != 0) {
                                this.buffer.append('\u2003');
                            }
                            if (Double.isNaN(value = results[i])) {
                                try {
                                    String label = this.nodata.get(ValuesFormatter.toNodataKey(i, (float)value));
                                    if (label != null) {
                                        return label;
                                    }
                                }
                                catch (IllegalArgumentException e) {
                                    this.recoverableException("evaluate", e);
                                }
                            }
                            this.sampleFormats[i].format(value, this.buffer, this.field).append(this.units[i]);
                        }
                        return this.buffer.toString();
                    }
                    catch (CannotEvaluateException e) {
                        this.recoverableException("evaluate", (Exception)((Object)e));
                    }
                }
            }
            return this.outsideText;
        }
    }

    private static Long toNodataKey(int band, float value) {
        return Numerics.tuple((int)MathFunctions.toNanOrdinal((float)value), (int)band);
    }

    private static Integer suggestFractionDigits(TransferFunction formula, SampleDimension isd) {
        int nf;
        if (formula.getType() != TransferFunctionType.LINEAR) {
            nf = -2;
        } else {
            double resolution = formula.getScale();
            if (resolution > 0.0 && resolution <= Double.MAX_VALUE) {
                Optional range = isd.getSampleRange();
                if (range.isPresent()) {
                    resolution *= 0.5 / ((NumberRange)range.get()).getSpan() + 1.0;
                }
                if ((nf = DecimalFunctions.fractionDigitsForDelta((double)resolution, (boolean)false)) < -9 || nf > 6) {
                    nf = -2;
                }
            } else {
                nf = -1;
            }
        }
        return nf;
    }

    private void recoverableException(String method, Exception e) {
        String message = e.getMessage();
        if (!message.equals(this.lastErrorMessage)) {
            this.lastErrorMessage = message;
            Logging.recoverableException((Logger)LogHandler.LOGGER, ValuesUnderCursor.class, (String)method, (Throwable)e);
        }
    }

    private static /* synthetic */ Comparable[] lambda$setSelectedBands$5() {
        return new Comparable[]{Integer.valueOf(65535)};
    }

    private static final class Position
    extends AbstractDirectPosition {
        private final double[] coordinates;
        private final CoordinateReferenceSystem crs;
        final GridExtent newSlice;

        Position(DirectPosition position, GridExtent slice) {
            this.coordinates = position.getCoordinate();
            this.crs = position.getCoordinateReferenceSystem();
            this.newSlice = slice;
        }

        public int getDimension() {
            return this.coordinates.length;
        }

        public double getCoordinate(int dimension) {
            return this.coordinates[dimension];
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.crs;
        }
    }
}

