/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.core.definition.OperationMeta;

public class RestParam {
    private static final JavaType STRING_ARRAY_TYPE = TypeFactory.defaultInstance().constructArrayType(String.class);
    protected ParamValueProcessor paramProcessor;
    protected String paramName;

    public RestParam(OperationMeta operationMeta, Parameter parameter, Type genericParamType) {
        this.paramName = parameter.getName();
        this.init(operationMeta, parameter, genericParamType);
    }

    public RestParam(OperationMeta operationMeta, String paramName, RequestBody parameter, boolean isForm, Type genericParamType) {
        this.paramName = paramName;
        this.init(operationMeta, parameter, isForm, genericParamType);
    }

    public ParamValueProcessor getParamProcessor() {
        return this.paramProcessor;
    }

    public void setParamProcessor(ParamValueProcessor paramProcessor) {
        this.paramProcessor = paramProcessor;
    }

    public String getParamName() {
        return this.paramName;
    }

    protected void init(OperationMeta operationMeta, Parameter parameter, Type genericParamType) {
        String paramType = parameter.getIn();
        ParamValueProcessorCreator creator = (ParamValueProcessorCreator)ParamValueProcessorCreatorManager.INSTANCE.ensureFindValue(paramType);
        this.setParamProcessor(creator.create(operationMeta, parameter.getName(), parameter, genericParamType));
    }

    protected void init(OperationMeta operationMeta, RequestBody parameter, boolean isForm, Type genericParamType) {
        ParamValueProcessorCreator creator = isForm ? (ParamValueProcessorCreator)ParamValueProcessorCreatorManager.INSTANCE.ensureFindValue("formData") : (ParamValueProcessorCreator)ParamValueProcessorCreatorManager.INSTANCE.ensureFindValue("body");
        this.setParamProcessor(creator.create(operationMeta, this.paramName, parameter, genericParamType));
    }

    public <T> T getValue(Map<String, Object> args) {
        return (T)args.get(this.paramName);
    }

    public String[] getValueAsStrings(Map<String, Object> args) {
        Object value = args.get(this.paramName);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray() || value instanceof Collection) {
            return (String[])this.paramProcessor.convertValue(value, STRING_ARRAY_TYPE);
        }
        return new String[]{String.valueOf(value)};
    }
}

