/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.reflect.TypeToken;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiParam;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import io.swagger.util.ReflectionUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.inject.PlaceholderResolver;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.ParameterProcessor;
import org.apache.servicecomb.swagger.generator.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerConst;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;
import org.apache.servicecomb.swagger.jakarta.ModelConvertersAdapterJakarta;
import org.apache.servicecomb.swagger.jakarta.ParameterProcessorAdapterJakarta;

public abstract class AbstractOperationGenerator
implements OperationGenerator {
    protected AbstractSwaggerGenerator swaggerGenerator;
    protected Swagger swagger;
    protected Class<?> clazz;
    protected Method method;
    protected String httpMethod;
    protected List<ParameterGenerator> parameterGenerators = new ArrayList<ParameterGenerator>();
    protected String path;
    protected Operation swaggerOperation;
    protected Map<String, Property> methodResponseHeaders = new LinkedHashMap<String, Property>();
    private static final List<String> NOT_NULL_ANNOTATIONS = Arrays.asList("NotBlank", "NotEmpty");

    public AbstractOperationGenerator(AbstractSwaggerGenerator swaggerGenerator, Method method) {
        this.swaggerGenerator = swaggerGenerator;
        this.swagger = swaggerGenerator.getSwagger();
        this.clazz = swaggerGenerator.getClazz();
        this.method = method;
        this.httpMethod = swaggerGenerator.getHttpMethod();
        this.swaggerOperation = new Operation();
    }

    @Override
    public void addMethodResponseHeader(String name, Property header) {
        this.methodResponseHeaders.put(name, header);
    }

    @Override
    public void setHttpMethod(String httpMethod) {
        if (StringUtils.isEmpty((CharSequence)httpMethod)) {
            return;
        }
        this.httpMethod = httpMethod.toLowerCase(Locale.US);
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Operation getOperation() {
        return this.swaggerOperation;
    }

    public String getOperationId() {
        return this.swaggerOperation.getOperationId();
    }

    @Override
    public void setPath(String path) {
        if (!((String)(path = new PlaceholderResolver().replaceFirst((String)path))).startsWith("/")) {
            path = "/" + (String)path;
        }
        this.path = path;
    }

    @Override
    public void generateResponse() {
        this.scanMethodAnnotation();
        this.scanResponse();
        this.correctOperation();
    }

    public void generate() {
        this.scanMethodAnnotation();
        this.scanMethodParameters();
        this.scanResponse();
        this.correctOperation();
        SwaggerGeneratorUtils.postProcessOperation(this.swaggerGenerator, this);
    }

    protected void scanMethodAnnotation() {
        for (Annotation annotation : Arrays.stream(this.method.getAnnotations()).sorted(Comparator.comparing(a -> a.annotationType().getName())).collect(Collectors.toList())) {
            MethodAnnotationProcessor<Annotation> processor = SwaggerGeneratorUtils.findMethodAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(this.swaggerGenerator, this, annotation);
        }
        if (StringUtils.isEmpty((CharSequence)this.swaggerOperation.getOperationId())) {
            this.swaggerOperation.setOperationId(MethodUtils.findSwaggerMethodName(this.method));
        }
        this.setDefaultTag();
    }

    private void setDefaultTag() {
        if (null != this.swaggerOperation.getTags()) {
            for (String tag : this.swaggerOperation.getTags()) {
                if (!StringUtils.isNotEmpty((CharSequence)tag)) continue;
                return;
            }
        }
        if (!this.swaggerGenerator.getDefaultTags().isEmpty()) {
            this.swaggerOperation.setTags(new ArrayList<String>(this.swaggerGenerator.getDefaultTags()));
        }
    }

    protected void scanMethodParameters() {
        this.initParameterGenerators();
        HashSet<String> names = new HashSet<String>();
        for (ParameterGenerator parameterGenerator : this.parameterGenerators) {
            this.scanMethodParameter(parameterGenerator);
            if (!names.add(parameterGenerator.getParameterName())) {
                throw new IllegalStateException(String.format("not support duplicated parameter, name=%s.", parameterGenerator.getParameterName()));
            }
            this.swaggerOperation.addParameter(parameterGenerator.getGeneratedParameter());
        }
    }

    private void initParameterGenerators() {
        Map<String, List<Annotation>> methodAnnotationMap = this.initMethodAnnotationByParameterName();
        this.initMethodParameterGenerators(methodAnnotationMap);
        this.initRemainMethodAnnotationsParameterGenerators(methodAnnotationMap);
        long bodyCount = this.parameterGenerators.stream().filter(p -> p.getHttpParameterType().equals((Object)HttpParameterType.BODY)).count();
        if (bodyCount > 1L) {
            throw new IllegalStateException(String.format("defined %d body parameter.", bodyCount));
        }
    }

    protected void initMethodParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        for (java.lang.reflect.Parameter methodParameter : this.method.getParameters()) {
            Type genericType = TypeToken.of(this.clazz).resolveType(methodParameter.getParameterizedType()).getType();
            ParameterGenerator parameterGenerator = new ParameterGenerator(this.method, methodAnnotationMap, methodParameter, genericType);
            this.validateParameter(parameterGenerator.getGenericType());
            if (SwaggerGeneratorUtils.isContextParameter(parameterGenerator.getGenericType())) continue;
            if (this.isAggregatedParameter(parameterGenerator, methodParameter)) {
                this.extractAggregatedParameterGenerators(methodAnnotationMap, methodParameter);
                continue;
            }
            this.parameterGenerators.add(parameterGenerator);
        }
    }

    protected boolean isAggregatedParameter(ParameterGenerator parameterGenerator, java.lang.reflect.Parameter methodParameter) {
        return false;
    }

    protected void extractAggregatedParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap, java.lang.reflect.Parameter methodParameter) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(methodParameter.getParameterizedType());
        BeanDescription beanDescription = Json.mapper().getSerializationConfig().introspect(javaType);
        for (BeanPropertyDefinition propertyDefinition : beanDescription.findProperties()) {
            if (!propertyDefinition.couldSerialize()) continue;
            Annotation[] annotations = SwaggerGeneratorUtils.collectAnnotations(propertyDefinition);
            ParameterGenerator propertyParameterGenerator = new ParameterGenerator(this.method, methodAnnotationMap, propertyDefinition.getName(), annotations, (Type)propertyDefinition.getPrimaryType());
            this.parameterGenerators.add(propertyParameterGenerator);
        }
    }

    protected void initRemainMethodAnnotationsParameterGenerators(Map<String, List<Annotation>> methodAnnotationMap) {
        for (Map.Entry<String, List<Annotation>> entry : methodAnnotationMap.entrySet()) {
            ParameterGenerator parameterGenerator = new ParameterGenerator(entry.getKey(), entry.getValue());
            this.parameterGenerators.add(parameterGenerator);
        }
    }

    private Map<String, List<Annotation>> initMethodAnnotationByParameterName() {
        LinkedHashMap<String, List<Annotation>> methodAnnotations = new LinkedHashMap<String, List<Annotation>>();
        for (Annotation annotation : this.clazz.getAnnotations()) {
            if (!(annotation instanceof ApiImplicitParams)) continue;
            for (ApiImplicitParam apiImplicitParam : ((ApiImplicitParams)annotation).value()) {
                this.addMethodAnnotationByParameterName(methodAnnotations, apiImplicitParam.name(), (Annotation)apiImplicitParam);
            }
        }
        for (Annotation annotation : this.method.getAnnotations()) {
            if (annotation instanceof ApiImplicitParams) {
                for (ApiImplicitParam apiImplicitParam : ((ApiImplicitParams)annotation).value()) {
                    this.addMethodAnnotationByParameterName(methodAnnotations, apiImplicitParam.name(), (Annotation)apiImplicitParam);
                }
                continue;
            }
            if (!(annotation instanceof ApiParam)) continue;
            this.addMethodAnnotationByParameterName(methodAnnotations, ((ApiParam)annotation).name(), annotation);
        }
        return methodAnnotations;
    }

    private void addMethodAnnotationByParameterName(Map<String, List<Annotation>> methodAnnotations, String name, Annotation annotation) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalStateException(String.format("%s.name should not be empty. method=%s:%s", annotation.annotationType().getSimpleName(), this.method.getDeclaringClass().getName(), this.method.getName()));
        }
        methodAnnotations.computeIfAbsent(name, n -> new ArrayList()).add(annotation);
    }

    protected void validateParameter(JavaType type) {
        if (type.isTypeOrSubTypeOf(HttpServletResponse.class)) {
            throw new IllegalStateException("all input/output of ServiceComb operation are models, not allow to use HttpServletResponse.");
        }
    }

    protected void scanMethodParameter(ParameterGenerator parameterGenerator) {
        Parameter parameter = this.createParameter(parameterGenerator);
        try {
            this.fillParameter(this.swagger, parameter, parameterGenerator.getParameterName(), parameterGenerator.getGenericType(), parameterGenerator.getAnnotations());
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("failed to fill parameter, parameterName=%s.", parameterGenerator.getParameterName()), e);
        }
    }

    protected Parameter createParameter(ParameterGenerator parameterGenerator) {
        if (parameterGenerator.getGeneratedParameter() == null) {
            Parameter parameter = this.createParameter(parameterGenerator.getHttpParameterType());
            parameterGenerator.setGeneratedParameter(parameter);
        }
        parameterGenerator.getGeneratedParameter().setName(parameterGenerator.getParameterName());
        return parameterGenerator.getGeneratedParameter();
    }

    protected Parameter createParameter(HttpParameterType httpParameterType) {
        switch (httpParameterType) {
            case PATH: {
                return new PathParameter();
            }
            case QUERY: {
                return new QueryParameter();
            }
            case HEADER: {
                return new HeaderParameter();
            }
            case FORM: {
                return new FormParameter();
            }
            case COOKIE: {
                return new CookieParameter();
            }
            case BODY: {
                return new BodyParameter();
            }
        }
        throw new IllegalStateException("not support httpParameterType " + httpParameterType);
    }

    protected void fillParameter(Swagger swagger, Parameter parameter, String parameterName, JavaType type, List<Annotation> annotations) {
        for (Annotation annotation2 : annotations) {
            ParameterProcessor<Parameter, Annotation> processor = SwaggerGeneratorUtils.findParameterProcessors(annotation2.annotationType());
            if (processor == null) continue;
            processor.fillParameter(swagger, this.swaggerOperation, parameter, type, annotation2);
        }
        if (type == null) {
            return;
        }
        ParameterProcessor<Parameter, Object> processor = SwaggerGeneratorUtils.findParameterProcessors((Type)type);
        if (processor != null) {
            processor.fillParameter(swagger, this.swaggerOperation, parameter, type, null);
        }
        if (parameter instanceof AbstractSerializableParameter) {
            ParameterProcessorAdapterJakarta.applyAnnotations(swagger, parameter, (Type)type, annotations);
            annotations.stream().forEach(annotation -> {
                if (NOT_NULL_ANNOTATIONS.contains(annotation.annotationType().getSimpleName())) {
                    parameter.setRequired(true);
                }
            });
            return;
        }
        this.fillBodyParameter(swagger, parameter, (Type)type, annotations);
    }

    protected void fillBodyParameter(Swagger swagger, Parameter parameter, Type type, List<Annotation> annotations) {
        Property property;
        BodyParameter newBodyParameter = (BodyParameter)ParameterProcessorAdapterJakarta.applyAnnotations(swagger, parameter, type, annotations);
        ModelImpl model = SwaggerUtils.getModelImpl(swagger, newBodyParameter);
        if (model != null && (property = ModelConvertersAdapterJakarta.getInstance().readAsProperty(type)) instanceof StringProperty) {
            model.setEnum(((StringProperty)property).getEnum());
        }
        if (((JavaType)type).getBindings().getTypeParameters().isEmpty()) {
            this.convertAnnotationProperty(((JavaType)type).getRawClass());
        } else {
            ((JavaType)type).getBindings().getTypeParameters().forEach(javaType -> this.convertAnnotationProperty(javaType.getRawClass()));
        }
        this.mergeBodyParameter((BodyParameter)parameter, newBodyParameter);
    }

    private void convertAnnotationProperty(Class<?> beanClass) {
        Map definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            return;
        }
        Field[] fields = beanClass.getDeclaredFields();
        Model model = (Model)definitions.get(beanClass.getSimpleName());
        if (model == null) {
            return;
        }
        Map properties = model.getProperties();
        if (properties != null) {
            Arrays.stream(fields).forEach(field -> {
                Property property;
                boolean requireItem = Arrays.stream(field.getAnnotations()).anyMatch(annotation -> NOT_NULL_ANNOTATIONS.contains(annotation.annotationType().getSimpleName()));
                if (requireItem && (property = (Property)properties.get(field.getName())) != null) {
                    property.setRequired(true);
                }
            });
        }
    }

    private void mergeBodyParameter(BodyParameter bodyParameter, BodyParameter fromBodyParameter) {
        if (fromBodyParameter.getExamples() != null) {
            bodyParameter.setExamples(fromBodyParameter.getExamples());
        }
        if (fromBodyParameter.getRequired()) {
            bodyParameter.setRequired(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)fromBodyParameter.getDescription())) {
            bodyParameter.setDescription(fromBodyParameter.getDescription());
        }
        if (StringUtils.isNotEmpty((CharSequence)fromBodyParameter.getAccess())) {
            bodyParameter.setAccess(fromBodyParameter.getAccess());
        }
        if (fromBodyParameter.getSchema() != null) {
            bodyParameter.setSchema(fromBodyParameter.getSchema());
        }
    }

    @Override
    public void addOperationToSwagger() {
        if (StringUtils.isEmpty((CharSequence)this.httpMethod)) {
            return;
        }
        Path pathObj = this.swagger.getPath(this.path);
        if (pathObj == null) {
            pathObj = new Path();
            this.swagger.path(this.path, pathObj);
        }
        HttpMethod hm = HttpMethod.valueOf((String)this.httpMethod.toUpperCase(Locale.US));
        if (pathObj.getOperationMap().get(hm) != null) {
            throw new IllegalStateException(String.format("Only allowed one default path. method=%s:%s.", this.method.getDeclaringClass().getName(), this.method.getName()));
        }
        pathObj.set(this.httpMethod, this.swaggerOperation);
    }

    public void correctOperation() {
        if (this.swaggerOperation.getConsumes() == null && this.swaggerOperation.getParameters().stream().anyMatch(SwaggerUtils::isFileParameter)) {
            this.swaggerOperation.addConsumes("multipart/form-data");
        }
        SwaggerUtils.correctResponses(this.swaggerOperation);
        this.addHeaderToResponse();
    }

    private void addHeaderToResponse() {
        for (Map.Entry responseEntry : this.swaggerOperation.getResponses().entrySet()) {
            Response response = (Response)responseEntry.getValue();
            for (Map.Entry<String, Property> entry : this.methodResponseHeaders.entrySet()) {
                if (response.getHeaders() != null && response.getHeaders().containsKey(entry.getKey())) continue;
                response.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void scanResponse() {
        Response successResponse;
        if (this.swaggerOperation.getResponses() != null && (successResponse = (Response)this.swaggerOperation.getResponses().get(SwaggerConst.SUCCESS_KEY)) != null) {
            if (successResponse.getResponseSchema() == null) {
                Model model = this.createResponseModel();
                successResponse.setResponseSchema(model);
            }
            return;
        }
        Model model = this.createResponseModel();
        Response response = new Response();
        response.setResponseSchema(model);
        this.swaggerOperation.addResponse(SwaggerConst.SUCCESS_KEY, response);
    }

    protected Model createResponseModel() {
        Type responseType = TypeToken.of(this.clazz).resolveType(this.method.getGenericReturnType()).getType();
        if (ReflectionUtils.isVoid((Type)responseType)) {
            return null;
        }
        ResponseTypeProcessor processor = SwaggerGeneratorUtils.findResponseTypeProcessor(responseType);
        return processor.process(this.swaggerGenerator, this, responseType);
    }

    public Method getMethod() {
        return this.method;
    }

    public List<ParameterGenerator> getParameterGenerators() {
        return this.parameterGenerators;
    }

    public Operation getSwaggerOperation() {
        return this.swaggerOperation;
    }
}

