/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.reactivex.rxjava3.core.Flowable;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;
import org.apache.servicecomb.swagger.invocation.sse.SseEventResponseEntity;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ProduceEventStreamProcessor
implements ProduceProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProduceEventStreamProcessor.class);
    private static final String CR_STR = "\r";
    private static final byte[] CR = "\r".getBytes(StandardCharsets.UTF_8);
    private static final String LF_STR = "\n";
    private static final byte[] LF = "\n".getBytes(StandardCharsets.UTF_8);
    private static final String CRLF_STR = "\r\n";
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    private String lineDelimiter;
    private byte[] lineDelimiterBytes;
    private int writeIndex = 0;
    private ProcessStatus loopStatus = ProcessStatus.DETERMINE_LINE_DELIMITER;
    private int matchingDelimiterIndex = 0;
    final ByteBuf buffer = Unpooled.buffer();
    private SseEventResponseEntity<?> currentEntity = new SseEventResponseEntity();
    private List<SseEventResponseEntity<?>> entityList = new ArrayList();
    private JavaType type;

    @Override
    public String getName() {
        return "text/event-stream";
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void doEncodeResponse(OutputStream output, Object result) throws Exception {
        StringBuilder eventBuilder = new StringBuilder();
        if (result instanceof SseEventResponseEntity) {
            SseEventResponseEntity responseEntity = (SseEventResponseEntity)result;
            this.appendId(eventBuilder, responseEntity.getId());
            this.appendEvent(eventBuilder, responseEntity.getEvent());
            this.appendRetry(eventBuilder, responseEntity.getRetry());
            this.appendData(eventBuilder, responseEntity.getData());
            eventBuilder.append(LF_STR);
            output.write(eventBuilder.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            LOGGER.warn("Does not support encoding objects other than SseEventResponseEntity!");
        }
    }

    @Override
    public List<SseEventResponseEntity<?>> doDecodeResponse(InputStream input, JavaType type) throws Exception {
        int bytesRead;
        this.type = type;
        byte[] readCache = new byte[Math.min(128, input.available())];
        while ((bytesRead = input.read(readCache)) > 0) {
            this.processAllBytes(readCache, bytesRead);
        }
        List<SseEventResponseEntity<?>> resultList = this.entityList;
        this.entityList = new ArrayList();
        return resultList;
    }

    private void processAllBytes(byte[] readCache, int cacheEndPos) {
        int lastProcessedPosition = this.innerLoop(readCache, 0, cacheEndPos);
        while (lastProcessedPosition < cacheEndPos) {
            lastProcessedPosition = this.innerLoop(readCache, lastProcessedPosition, cacheEndPos);
        }
    }

    private int innerLoop(byte[] readCache, int startPos, int cacheEndPos) {
        if (startPos >= cacheEndPos) {
            return cacheEndPos;
        }
        switch (this.loopStatus) {
            case MATCHING_CR: {
                return this.tryToMatchDelimiterCR(readCache, startPos, cacheEndPos);
            }
            case MATCHING_CRLF: {
                return this.tryToMatchDelimiterCRLF(readCache, startPos, cacheEndPos);
            }
            case MATCHING_LF: {
                return this.tryToMatchDelimiterLF(readCache, startPos, cacheEndPos);
            }
            case DETERMINE_LINE_DELIMITER: {
                return this.searchFirstLineDelimiter(readCache, startPos, cacheEndPos);
            }
            case MATCHING_LINE: {
                return this.bufferReadCacheAndProcessLines(readCache, startPos, cacheEndPos);
            }
            case END_OF_STREAM: {
                return this.processLeftBuffer(cacheEndPos);
            }
        }
        throw new IllegalStateException("unexpected case");
    }

    private int processLeftBuffer(int cacheEndPos) {
        byte[] bytes = this.readAllBytesFromBuffer(this.buffer);
        String bufferStr = new String(bytes, StandardCharsets.UTF_8);
        this.processStringBuffer(bufferStr);
        return cacheEndPos;
    }

    private int bufferReadCacheAndProcessLines(byte[] readCache, int startPos, int cacheEndPos) {
        this.buffer.writeBytes(readCache, startPos, cacheEndPos - startPos);
        this.processAllAvailableBufferLines();
        return cacheEndPos;
    }

    private int tryToMatchDelimiterCR(byte[] readCache, int startPos, int cacheEndPos) {
        int bytesProcessed = 0;
        while (this.matchingDelimiterIndex < CR.length && startPos + bytesProcessed < cacheEndPos) {
            if (readCache[startPos + bytesProcessed] == CR[this.matchingDelimiterIndex]) {
                this.buffer.writeByte((int)readCache[startPos + bytesProcessed]);
                ++this.matchingDelimiterIndex;
            } else {
                this.loopStatus = ProcessStatus.DETERMINE_LINE_DELIMITER;
                this.matchingDelimiterIndex = 0;
                return startPos + bytesProcessed;
            }
            ++bytesProcessed;
        }
        if (this.matchingDelimiterIndex == CR.length) {
            this.loopStatus = ProcessStatus.MATCHING_CRLF;
        }
        return startPos + bytesProcessed;
    }

    private int tryToMatchDelimiterCRLF(byte[] readCache, int startPos, int cacheEndPos) {
        int bytesProcessed = 0;
        while (this.matchingDelimiterIndex < CRLF.length && startPos + bytesProcessed < cacheEndPos) {
            if (readCache[startPos + bytesProcessed] == CRLF[this.matchingDelimiterIndex]) {
                this.buffer.writeByte((int)readCache[startPos + bytesProcessed]);
                ++this.matchingDelimiterIndex;
            } else {
                this.determineDelimiter(CR_STR, CR);
                return startPos + bytesProcessed;
            }
            ++bytesProcessed;
        }
        if (this.matchingDelimiterIndex == CRLF.length) {
            this.determineDelimiter(CRLF_STR, CRLF);
        }
        return startPos + bytesProcessed;
    }

    private int tryToMatchDelimiterLF(byte[] readCache, int startPos, int cacheEndPos) {
        int bytesProcessed = 0;
        while (this.matchingDelimiterIndex < LF.length && startPos + bytesProcessed < cacheEndPos) {
            if (readCache[startPos + bytesProcessed] == LF[this.matchingDelimiterIndex]) {
                this.buffer.writeByte((int)readCache[startPos + bytesProcessed]);
                ++this.matchingDelimiterIndex;
            } else {
                this.loopStatus = ProcessStatus.DETERMINE_LINE_DELIMITER;
                this.matchingDelimiterIndex = 0;
                return startPos + bytesProcessed;
            }
            ++bytesProcessed;
        }
        if (this.matchingDelimiterIndex == LF.length) {
            this.determineDelimiter(LF_STR, LF);
        }
        return startPos + bytesProcessed;
    }

    private void determineDelimiter(String delimiterStr, byte[] delimiterBytes) {
        this.lineDelimiter = delimiterStr;
        this.lineDelimiterBytes = delimiterBytes;
        this.matchingDelimiterIndex = 0;
        this.loopStatus = ProcessStatus.MATCHING_LINE;
    }

    private int searchFirstLineDelimiter(byte[] readCache, int startPos, int cacheEndPos) {
        for (int i = startPos; i < cacheEndPos; ++i) {
            if (readCache[i] == CR[0]) {
                this.loopStatus = ProcessStatus.MATCHING_CR;
                this.matchingDelimiterIndex = 0;
                return i;
            }
            if (readCache[i] == LF[0]) {
                this.loopStatus = ProcessStatus.MATCHING_LF;
                this.matchingDelimiterIndex = 0;
                return i;
            }
            this.buffer.writeByte((int)readCache[i]);
        }
        return cacheEndPos;
    }

    private void processAllAvailableBufferLines() {
        while (this.buffer.readableBytes() > 0) {
            byte[] bytes = this.readALineOfBytesFromBuffer(this.buffer);
            if (bytes == null || bytes.length == 0) {
                return;
            }
            String bufferStr = new String(bytes, StandardCharsets.UTF_8);
            this.processStringBuffer(bufferStr);
        }
    }

    private void processStringBuffer(String bufferStr) {
        int delimiterIdx;
        int cursor = 0;
        while ((delimiterIdx = bufferStr.indexOf(this.lineDelimiter, cursor)) >= 0) {
            String line = bufferStr.substring(cursor, delimiterIdx);
            this.processStringLine(line);
            cursor = delimiterIdx + this.lineDelimiter.length();
        }
        if (cursor < bufferStr.length()) {
            this.buffer.writeBytes(bufferStr.substring(cursor).getBytes(StandardCharsets.UTF_8));
        }
    }

    private void processStringLine(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            if (this.currentEntity.isEmpty()) {
                return;
            }
            this.entityList.add(this.currentEntity);
            this.currentEntity = new SseEventResponseEntity();
            return;
        }
        String[] split = line.split(":", 2);
        if (split.length < 2) {
            LOGGER.error("get a line of sse event without colon! stream is breaking!");
            throw new IllegalStateException("get a line of sse event without colon!");
        }
        switch (split[0]) {
            case "event": {
                if (!StringUtils.isNotBlank((CharSequence)split[1])) break;
                this.currentEntity.event(split[1].trim());
                break;
            }
            case "id": {
                if (!StringUtils.isNotBlank((CharSequence)split[1])) break;
                this.currentEntity.id(Integer.parseInt(split[1].trim()));
                break;
            }
            case "data": {
                try {
                    this.currentEntity.data(RestObjectMapperFactory.getRestObjectMapper().readValue(split[1].trim(), this.type));
                    break;
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("failed to process data of sse event: [{}]", (Object)e.getMessage());
                    throw new IllegalStateException("failed to process data of sse event", e);
                }
            }
            case "retry": {
                if (!StringUtils.isNotBlank((CharSequence)split[1])) break;
                this.currentEntity.retry(Long.parseLong(split[1].trim()));
                break;
            }
            default: {
                LOGGER.debug("unrecognized sse message line! ignored string segment length=[{}]", (Object)line.length());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readALineOfBytesFromBuffer(ByteBuf buffer) {
        this.matchingDelimiterIndex = 0;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(buffer.readableBytes());){
            while (buffer.readableBytes() > 0 && this.matchingDelimiterIndex < this.lineDelimiterBytes.length) {
                byte b = buffer.readByte();
                if (b == this.lineDelimiterBytes[this.matchingDelimiterIndex]) {
                    ++this.matchingDelimiterIndex;
                }
                bos.write(b);
            }
            if (this.matchingDelimiterIndex < this.lineDelimiterBytes.length) {
                buffer.writeBytes(bos.toByteArray());
                byte[] byArray = null;
                return byArray;
            }
            this.matchingDelimiterIndex = 0;
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("impossible error while closing ByteArrayOutputStream", e);
        }
    }

    private byte[] readAllBytesFromBuffer(ByteBuf buffer) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(buffer.readableBytes());
        try {
            buffer.readBytes((OutputStream)bos, buffer.readableBytes());
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("impossible error while closing ByteArrayOutputStream", e);
            }
        }
        bos.close();
        return byArray;
    }

    private void appendId(StringBuilder eventBuilder, Integer eventId) {
        int n;
        if (eventId != null) {
            n = eventId;
        } else {
            int n2 = this.writeIndex;
            n = n2;
            this.writeIndex = n2 + 1;
        }
        int id = n;
        eventBuilder.append("id: ").append(id).append(LF_STR);
    }

    private void appendEvent(StringBuilder eventBuilder, String event) {
        if (StringUtils.isEmpty((CharSequence)event)) {
            return;
        }
        eventBuilder.append("event: ").append(event).append(LF_STR);
    }

    private void appendRetry(StringBuilder eventBuilder, Long retry) {
        if (retry == null) {
            return;
        }
        eventBuilder.append("retry: ").append(retry).append(LF_STR);
    }

    private void appendData(StringBuilder eventBuilder, List<?> datas) throws Exception {
        if (CollectionUtils.isEmpty(datas)) {
            throw new Exception("sse response data is null!");
        }
        for (Object data : datas) {
            eventBuilder.append("data: ").append(RestObjectMapperFactory.getRestObjectMapper().writeValueAsString(data)).append(LF_STR);
        }
    }

    public Publisher<SseEventResponseEntity<?>> decodeResponse(Buffer buffer, JavaType type) throws Exception {
        if (buffer.length() == 0) {
            return Flowable.empty();
        }
        try (BufferInputStream input = new BufferInputStream(buffer.getByteBuf());){
            Object list = this.doDecodeResponse((InputStream)input, type);
            Flowable flowable = Flowable.fromIterable((Iterable)list);
            return flowable;
        }
    }

    public Publisher<SseEventResponseEntity<?>> close() throws Exception {
        if (this.type == null) {
            return Flowable.empty();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream((this.lineDelimiter + this.lineDelimiter).getBytes(StandardCharsets.UTF_8));){
            Object list = this.doDecodeResponse(input, this.type);
            Flowable flowable = Flowable.fromIterable((Iterable)list);
            return flowable;
        }
    }

    private static enum ProcessStatus {
        DETERMINE_LINE_DELIMITER,
        MATCHING_CR,
        MATCHING_LF,
        MATCHING_CRLF,
        MATCHING_LINE,
        END_OF_MESSAGE,
        END_OF_STREAM;

    }
}

