/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Extension;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.parser.ExtensionRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractExtensionRegistry
implements ExtensionRegistry {
    private final ConcurrentMap<String, Map<String, Field>> fieldCache = new ConcurrentHashMap<String, Map<String, Field>>();

    protected AbstractExtensionRegistry() {
    }

    @Override
    public void registerExtension(Extension extension) {
        String fullyQualifiedName = extension.getExtendee().getFullyQualifiedName();
        this.fieldCache.remove(fullyQualifiedName);
    }

    @Override
    public Collection<Extension> getExtensions(Message message) {
        String fullyQualifiedName = message.getFullyQualifiedName();
        return this.getExtensions(fullyQualifiedName);
    }

    @Override
    public Map<String, Field> getExtensionFields(String fullMessageName) {
        return this.fieldCache.computeIfAbsent(fullMessageName, messageName -> {
            HashMap<String, Field> map = new HashMap<String, Field>();
            Collection<Extension> extensions = this.getExtensions((String)messageName);
            for (Extension extension : extensions) {
                for (Field field : extension.getFields()) {
                    String key = extension.getNamespace() + field.getName();
                    map.put(key, field);
                }
            }
            return map;
        });
    }

    @Override
    public Map<String, Field> getExtensionFields(Message message) {
        String fullyQualifiedName = message.getFullyQualifiedName();
        return this.getExtensionFields(fullyQualifiedName);
    }
}

