/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.stats.distribution;

import com.netflix.stats.distribution.DataAccumulator;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DataPublisher {
    private static final String THREAD_NAME = "DataPublisher";
    private static final boolean DAEMON_THREADS = true;
    private static ScheduledExecutorService sharedExecutor = null;
    private final DataAccumulator accumulator;
    private final long delayMillis;
    private Future<?> future = null;

    public DataPublisher(DataAccumulator accumulator, long delayMillis) {
        this.accumulator = accumulator;
        this.delayMillis = delayMillis;
    }

    public DataAccumulator getDataAccumulator() {
        return this.accumulator;
    }

    public synchronized boolean isRunning() {
        return this.future != null;
    }

    public synchronized void start() {
        if (this.future == null) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        DataPublisher.this.accumulator.publish();
                    }
                    catch (Exception e) {
                        DataPublisher.this.handleException(e);
                    }
                }
            };
            this.future = this.getExecutor().scheduleWithFixedDelay(task, this.delayMillis, this.delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized ScheduledExecutorService getExecutor() {
        if (sharedExecutor == null) {
            sharedExecutor = Executors.newScheduledThreadPool(1, new PublishThreadFactory());
        }
        return sharedExecutor;
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    protected void handleException(Exception e) {
    }

    private static final class PublishThreadFactory
    implements ThreadFactory {
        PublishThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, DataPublisher.THREAD_NAME);
            t.setDaemon(true);
            return t;
        }
    }
}

