/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.apache.rocketmq.client.java.impl.producer.ProducerImpl;
import org.apache.rocketmq.client.java.message.MessageBuilderImpl;

public class ProducerBuilderImpl
implements ProducerBuilder {
    private ClientConfiguration clientConfiguration = null;
    private final Set<String> topics = new HashSet<String>();
    private int maxAttempts = 3;
    private TransactionChecker checker = null;

    public ProducerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = (ClientConfiguration)Preconditions.checkNotNull((Object)clientConfiguration, (Object)"clientConfiguration should not be null");
        return this;
    }

    public ProducerBuilder setTopics(String ... topics) {
        Set set = Arrays.stream(topics).peek(topic -> Preconditions.checkNotNull((Object)topic, (Object)"topic should not be null")).peek(topic -> Preconditions.checkArgument((boolean)MessageBuilderImpl.TOPIC_PATTERN.matcher((CharSequence)topic).matches(), (String)"topic does not match the regex [regex=%s]", (Object)MessageBuilderImpl.TOPIC_PATTERN.pattern())).collect(Collectors.toSet());
        this.topics.addAll(set);
        return this;
    }

    public ProducerBuilder setMaxAttempts(int maxAttempts) {
        Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be positive");
        this.maxAttempts = maxAttempts;
        return this;
    }

    public ProducerBuilder setTransactionChecker(TransactionChecker checker) {
        this.checker = (TransactionChecker)Preconditions.checkNotNull((Object)checker, (Object)"checker should not set null");
        return this;
    }

    public Producer build() {
        Preconditions.checkNotNull((Object)this.clientConfiguration, (Object)"clientConfiguration has not been set yet");
        ProducerImpl producer = new ProducerImpl(this.clientConfiguration, this.topics, this.maxAttempts, this.checker);
        producer.startAsync().awaitRunning();
        return producer;
    }
}

