/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IpNameResolverFactory
extends NameResolverProvider {
    private final List<EquivalentAddressGroup> addresses;
    private final String serviceAuthority = "IPAuthority";
    private NameResolver.Listener2 listener2;

    public IpNameResolverFactory(List<InetSocketAddress> socketAddresses) {
        this.addresses = this.convertAddresses(socketAddresses);
    }

    private List<EquivalentAddressGroup> convertAddresses(List<InetSocketAddress> socketAddresses) {
        ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
        for (InetSocketAddress socketAddress : socketAddresses) {
            addresses.add(new EquivalentAddressGroup((SocketAddress)socketAddress));
        }
        Collections.shuffle(addresses);
        return addresses;
    }

    public NameResolver newNameResolver(URI notUsedUri, NameResolver.Args args) {
        return new NameResolver(){

            public String getServiceAuthority() {
                return "IPAuthority";
            }

            public void start(NameResolver.Listener2 listener2) {
                IpNameResolverFactory.this.listener2 = listener2;
                listener2.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(IpNameResolverFactory.this.addresses).build());
            }

            public void shutdown() {
            }
        };
    }

    public String getDefaultScheme() {
        return "IP";
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }
}

