/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.EndTransactionResponse;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.HeartbeatResponse;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.NotifyClientTerminationResponse;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryAssignmentResponse;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.TelemetryCommand;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLException;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.impl.Client;
import org.apache.rocketmq.client.java.impl.ClientManager;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.misc.ExecutorServices;
import org.apache.rocketmq.client.java.misc.MetadataUtils;
import org.apache.rocketmq.client.java.misc.ThreadFactoryImpl;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.rpc.Context;
import org.apache.rocketmq.client.java.rpc.RpcClient;
import org.apache.rocketmq.client.java.rpc.RpcClientImpl;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.apache.rocketmq.shaded.io.grpc.Metadata;
import org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ClientManagerImpl
extends ClientManager {
    public static final Duration RPC_CLIENT_MAX_IDLE_DURATION = Duration.ofMinutes(30L);
    public static final Duration RPC_CLIENT_IDLE_CHECK_INITIAL_DELAY = Duration.ofSeconds(5L);
    public static final Duration RPC_CLIENT_IDLE_CHECK_PERIOD = Duration.ofMinutes(1L);
    public static final Duration HEART_BEAT_INITIAL_DELAY = Duration.ofSeconds(1L);
    public static final Duration HEART_BEAT_PERIOD = Duration.ofSeconds(10L);
    public static final Duration LOG_STATS_INITIAL_DELAY = Duration.ofSeconds(1L);
    public static final Duration LOG_STATS_PERIOD = Duration.ofSeconds(60L);
    public static final Duration SYNC_SETTINGS_DELAY = Duration.ofSeconds(1L);
    public static final Duration SYNC_SETTINGS_PERIOD = Duration.ofMinutes(5L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManagerImpl.class);
    private final Client client;
    @GuardedBy(value="rpcClientTableLock")
    private final Map<Endpoints, RpcClient> rpcClientTable;
    private final ReadWriteLock rpcClientTableLock;
    private final ScheduledExecutorService scheduler;
    private final ExecutorService asyncWorker;

    public ClientManagerImpl(Client client) {
        this.client = client;
        this.rpcClientTable = new HashMap<Endpoints, RpcClient>();
        this.rpcClientTableLock = new ReentrantReadWriteLock();
        long clientIndex = client.getClientId().getIndex();
        this.scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadFactoryImpl("ClientScheduler", clientIndex));
        this.asyncWorker = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("ClientAsyncWorker", clientIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIdleRpcClients() throws InterruptedException {
        this.rpcClientTableLock.writeLock().lock();
        try {
            Iterator<Map.Entry<Endpoints, RpcClient>> it = this.rpcClientTable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Endpoints, RpcClient> entry = it.next();
                Endpoints endpoints = entry.getKey();
                RpcClient rpcClient = entry.getValue();
                Duration idleDuration = rpcClient.idleDuration();
                if (idleDuration.compareTo(RPC_CLIENT_MAX_IDLE_DURATION) <= 0) continue;
                it.remove();
                rpcClient.shutdown();
                LOGGER.info("Rpc client has been idle for a long time, endpoints={}, idleDuration={}, rpcClientMaxIdleDuration={}, clientId={}", endpoints, idleDuration, RPC_CLIENT_MAX_IDLE_DURATION, this.client.getClientId());
            }
        }
        finally {
            this.rpcClientTableLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcClient getRpcClient(Endpoints endpoints) throws ClientException {
        RpcClient rpcClient;
        this.rpcClientTableLock.readLock().lock();
        try {
            rpcClient = this.rpcClientTable.get(endpoints);
            if (null != rpcClient) {
                RpcClient rpcClient2 = rpcClient;
                return rpcClient2;
            }
        }
        finally {
            this.rpcClientTableLock.readLock().unlock();
        }
        this.rpcClientTableLock.writeLock().lock();
        try {
            rpcClient = this.rpcClientTable.get(endpoints);
            if (null != rpcClient) {
                RpcClient rpcClient3 = rpcClient;
                return rpcClient3;
            }
            try {
                rpcClient = new RpcClientImpl(endpoints);
            }
            catch (SSLException e) {
                LOGGER.error("Failed to get RPC client, endpoints={}, clientId={}", endpoints, this.client.getClientId(), e);
                throw new ClientException("Failed to generate RPC client", e);
            }
            this.rpcClientTable.put(endpoints, rpcClient);
            RpcClient rpcClient4 = rpcClient;
            return rpcClient4;
        }
        finally {
            this.rpcClientTableLock.writeLock().unlock();
        }
    }

    @Override
    public RpcFuture<QueryRouteRequest, QueryRouteResponse> queryRoute(Endpoints endpoints, QueryRouteRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<QueryRouteResponse> future = rpcClient.queryRoute(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<QueryRouteRequest, QueryRouteResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<QueryRouteRequest, QueryRouteResponse>(t);
        }
    }

    @Override
    public RpcFuture<HeartbeatRequest, HeartbeatResponse> heartbeat(Endpoints endpoints, HeartbeatRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<HeartbeatResponse> future = rpcClient.heartbeat(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<HeartbeatRequest, HeartbeatResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<HeartbeatRequest, HeartbeatResponse>(t);
        }
    }

    @Override
    public RpcFuture<SendMessageRequest, SendMessageResponse> sendMessage(Endpoints endpoints, SendMessageRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<SendMessageResponse> future = rpcClient.sendMessage(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<SendMessageRequest, SendMessageResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<SendMessageRequest, SendMessageResponse>(t);
        }
    }

    @Override
    public RpcFuture<QueryAssignmentRequest, QueryAssignmentResponse> queryAssignment(Endpoints endpoints, QueryAssignmentRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<QueryAssignmentResponse> future = rpcClient.queryAssignment(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<QueryAssignmentRequest, QueryAssignmentResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<QueryAssignmentRequest, QueryAssignmentResponse>(t);
        }
    }

    @Override
    public RpcFuture<ReceiveMessageRequest, List<ReceiveMessageResponse>> receiveMessage(Endpoints endpoints, ReceiveMessageRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<List<ReceiveMessageResponse>> future = rpcClient.receiveMessage(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<ReceiveMessageRequest, List<ReceiveMessageResponse>>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<ReceiveMessageRequest, List<ReceiveMessageResponse>>(t);
        }
    }

    @Override
    public RpcFuture<AckMessageRequest, AckMessageResponse> ackMessage(Endpoints endpoints, AckMessageRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<AckMessageResponse> future = rpcClient.ackMessage(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<AckMessageRequest, AckMessageResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<AckMessageRequest, AckMessageResponse>(t);
        }
    }

    @Override
    public RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> changeInvisibleDuration(Endpoints endpoints, ChangeInvisibleDurationRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<ChangeInvisibleDurationResponse> future = rpcClient.changeInvisibleDuration(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse>(t);
        }
    }

    @Override
    public RpcFuture<ForwardMessageToDeadLetterQueueRequest, ForwardMessageToDeadLetterQueueResponse> forwardMessageToDeadLetterQueue(Endpoints endpoints, ForwardMessageToDeadLetterQueueRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<ForwardMessageToDeadLetterQueueResponse> future = rpcClient.forwardMessageToDeadLetterQueue(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<ForwardMessageToDeadLetterQueueRequest, ForwardMessageToDeadLetterQueueResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<ForwardMessageToDeadLetterQueueRequest, ForwardMessageToDeadLetterQueueResponse>(t);
        }
    }

    @Override
    public RpcFuture<EndTransactionRequest, EndTransactionResponse> endTransaction(Endpoints endpoints, EndTransactionRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<EndTransactionResponse> future = rpcClient.endTransaction(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<EndTransactionRequest, EndTransactionResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<EndTransactionRequest, EndTransactionResponse>(t);
        }
    }

    @Override
    public RpcFuture<NotifyClientTerminationRequest, NotifyClientTerminationResponse> notifyClientTermination(Endpoints endpoints, NotifyClientTerminationRequest request, Duration duration) {
        try {
            Metadata metadata = this.client.sign();
            Context context = new Context(endpoints, metadata);
            RpcClient rpcClient = this.getRpcClient(endpoints);
            ListenableFuture<NotifyClientTerminationResponse> future = rpcClient.notifyClientTermination(metadata, request, this.asyncWorker, duration);
            return new RpcFuture<NotifyClientTerminationRequest, NotifyClientTerminationResponse>(context, request, future);
        }
        catch (Throwable t) {
            return new RpcFuture<NotifyClientTerminationRequest, NotifyClientTerminationResponse>(t);
        }
    }

    @Override
    public StreamObserver<TelemetryCommand> telemetry(Endpoints endpoints, Duration duration, StreamObserver<TelemetryCommand> responseObserver) throws ClientException {
        try {
            Metadata metadata = this.client.sign();
            RpcClient rpcClient = this.getRpcClient(endpoints);
            return rpcClient.telemetry(metadata, this.asyncWorker, duration, responseObserver);
        }
        catch (Throwable t) {
            throw new InternalErrorException(t);
        }
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    protected void startUp() {
        ClientId clientId = this.client.getClientId();
        LOGGER.info("Begin to start the client manager, clientId={}", (Object)clientId);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.clearIdleRpcClients();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised during the clearing of idle rpc clients, clientId={}", (Object)clientId, (Object)t);
            }
        }, RPC_CLIENT_IDLE_CHECK_INITIAL_DELAY.toNanos(), RPC_CLIENT_IDLE_CHECK_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.client.doHeartbeat();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised during heartbeat, clientId={}", (Object)clientId, (Object)t);
            }
        }, HEART_BEAT_INITIAL_DELAY.toNanos(), HEART_BEAT_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                LOGGER.info("Start to log statistics, clientVersion={}, clientWrapperVersion={}, clientId={}", MetadataUtils.getVersion(), MetadataUtils.getWrapperVersion(), clientId);
                this.client.doStats();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised during statistics logging, clientId={}", (Object)clientId, (Object)t);
            }
        }, LOG_STATS_INITIAL_DELAY.toNanos(), LOG_STATS_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.client.syncSettings();
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised during the setting synchronization, clientId={}", (Object)clientId, (Object)t);
            }
        }, SYNC_SETTINGS_DELAY.toNanos(), SYNC_SETTINGS_PERIOD.toNanos(), TimeUnit.NANOSECONDS);
        LOGGER.info("The client manager starts successfully, clientId={}", (Object)clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutDown() throws IOException {
        ClientId clientId = this.client.getClientId();
        LOGGER.info("Begin to shutdown the client manager, clientId={}", (Object)clientId);
        this.scheduler.shutdown();
        try {
            if (!ExecutorServices.awaitTerminated(this.scheduler)) {
                LOGGER.error("[Bug] Timeout to shutdown the client scheduler, clientId={}", (Object)clientId);
            } else {
                LOGGER.info("Shutdown the client scheduler successfully, clientId={}", (Object)clientId);
            }
            this.rpcClientTableLock.writeLock().lock();
            try {
                Iterator<Map.Entry<Endpoints, RpcClient>> it = this.rpcClientTable.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Endpoints, RpcClient> entry = it.next();
                    RpcClient rpcClient = entry.getValue();
                    it.remove();
                    rpcClient.shutdown();
                }
            }
            finally {
                this.rpcClientTableLock.writeLock().unlock();
            }
            LOGGER.info("Shutdown all rpc client(s) successfully, clientId={}", (Object)clientId);
            this.asyncWorker.shutdown();
            if (!ExecutorServices.awaitTerminated(this.asyncWorker)) {
                LOGGER.error("[Bug] Timeout to shutdown the client async worker, clientId={}", (Object)clientId);
            } else {
                LOGGER.info("Shutdown the client async worker successfully, clientId={}", (Object)clientId);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("[Bug] Unexpected exception raised while shutdown client manager, clientId={}", (Object)clientId, (Object)e);
            throw new IOException(e);
        }
        LOGGER.info("Shutdown the client manager successfully, clientId={}", (Object)clientId);
    }

    @Override
    protected String serviceName() {
        return super.serviceName() + "-" + this.client.getClientId().getIndex();
    }
}

