/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerFifoMessageExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerFifoMessageExample.class);

    private ProducerFifoMessageExample() {
    }

    public static void main(String[] args) throws ClientException, IOException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String accessKey = "yourAccessKey";
        String secretKey = "yourSecretKey";
        StaticSessionCredentialsProvider sessionCredentialsProvider = new StaticSessionCredentialsProvider(accessKey, secretKey);
        String endpoints = "foobar.com:8080";
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setEndpoints(endpoints).setCredentialProvider((SessionCredentialsProvider)sessionCredentialsProvider).build();
        String topic = "yourFifoTopic";
        Producer producer = provider.newProducerBuilder().setClientConfiguration(clientConfiguration).setTopics(new String[]{topic}).build();
        byte[] body = "This is a FIFO message for Apache RocketMQ".getBytes(StandardCharsets.UTF_8);
        String tag = "yourMessageTagA";
        Message message = provider.newMessageBuilder().setTopic(topic).setTag(tag).setKeys(new String[]{"yourMessageKey-1ff69ada8e0e"}).setMessageGroup("youMessageGroup0").setBody(body).build();
        try {
            SendReceipt sendReceipt = producer.send(message);
            LOGGER.info("Send message successfully, messageId={}", (Object)sendReceipt.getMessageId());
        }
        catch (Throwable t) {
            LOGGER.error("Failed to send message", t);
        }
        producer.close();
    }
}

