/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method createAttributeNS creates an attribute of the given qualified name and namespace URI
 * Invoke the createAttributeNS method on this Document object with a valid values for
 * namespaceURI, and a qualifiedName as below.  This should return a valid Attr node.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-DocCrAttrNS</a>
 */
//BUG:eric's code treats QName as a localname here
public class documentcreateattributeNS02 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", false);
        Attr attribute1 = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:xml");
        String name = attribute1.getName();
        String nodeName = attribute1.getNodeName();
        String nodeValue = attribute1.getNodeValue();
        String prefix = attribute1.getPrefix();
        String namespaceURI = attribute1.getNamespaceURI();
        assertEquals("xml:xml", name, "documentcreateattributeNS02_att1_name");
        assertEquals("xml:xml", nodeName, "documentcreateattributeNS02_att1_nodeName");
        assertEquals("", nodeValue, "documentcreateattributeNS02_att1_nodeValue");
        assertEquals("xml", prefix, "documentcreateattributeNS02_att1_prefix");
        assertEquals("http://www.w3.org/XML/1998/namespace", namespaceURI, "documentcreateattributeNS02_att1_namespaceURI");
        Attr attribute2 = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        name = attribute2.getName();
        nodeName = attribute2.getNodeName();
        nodeValue = attribute2.getNodeValue();
        prefix = attribute2.getPrefix();
        namespaceURI = attribute2.getNamespaceURI();
        assertEquals("xmlns", name, "documentcreateattributeNS02_att2_name");
        assertEquals("xmlns", nodeName, "documentcreateattributeNS02_att2_nodeName");
        assertEquals("", nodeValue, "documentcreateattributeNS02_att2_nodeValue");
        assertEquals("http://www.w3.org/2000/xmlns/", namespaceURI, "documentcreateattributeNS02_att2_namespaceURI");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentcreateattributeNS02";
    }

}
