/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class ChannelDirectTcpip
extends AbstractClientChannel {
    private final SshdSocketAddress local;
    private final SshdSocketAddress remote;
    private ChannelPipedOutputStream pipe;

    public ChannelDirectTcpip(SshdSocketAddress local, SshdSocketAddress remote) {
        super("direct-tcpip");
        if (local == null) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                local = new SshdSocketAddress(localHost.getHostName(), 0);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to retrieve local host name");
            }
        }
        if (remote == null) {
            throw new IllegalArgumentException("Remote address must not be null");
        }
        this.local = local;
        this.remote = remote;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.remote, this.futureLock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        Session session = this.getSession();
        String remoteName = this.remote.getHostName();
        String localName = this.local.getHostName();
        LocalWindow wLocal = this.getLocalWindow();
        String type = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, type.length() + remoteName.length() + localName.length() + 64);
        buffer.putString(type);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(wLocal.getSize());
        buffer.putUInt(wLocal.getPacketSize());
        buffer.putString(remoteName);
        buffer.putUInt((long)this.remote.getPort());
        buffer.putString(localName);
        buffer.putUInt((long)this.local.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected void doOpen() throws IOException {
        if (this.streaming == StreamingChannel.Streaming.Async) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94);
            this.asyncOut = new ChannelAsyncInputStream(this);
        } else {
            this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            ChannelPipedInputStream pis = new ChannelPipedInputStream(this, this.getLocalWindow());
            this.pipe = new ChannelPipedOutputStream(pis);
            this.invertedOut = this.in = pis;
        }
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        this.pipe.write(data, off, (int)len);
        this.pipe.flush();
        LocalWindow wLocal = this.getLocalWindow();
        wLocal.check();
    }

    public SshdSocketAddress getLocalSocketAddress() {
        return this.local;
    }

    public SshdSocketAddress getRemoteSocketAddress() {
        return this.remote;
    }
}

