/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ChecksumUtils {
    private ChecksumUtils() {
    }

    @Deprecated
    public static String read(File checksumFile) throws IOException {
        String checksum;
        block16: {
            checksum = "";
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(checksumFile), StandardCharsets.UTF_8), 512);){
                String line;
                do {
                    if ((line = br.readLine()) != null) continue;
                    break block16;
                } while ((line = line.trim()).length() <= 0);
                checksum = line;
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    @Deprecated
    public static Map<String, Object> calc(File dataFile, Collection<String> algos) throws IOException {
        return ChecksumUtils.calc(new FileInputStream(dataFile), algos);
    }

    @Deprecated
    public static Map<String, Object> calc(byte[] dataBytes, Collection<String> algos) throws IOException {
        return ChecksumUtils.calc(new ByteArrayInputStream(dataBytes), algos);
    }

    private static Map<String, Object> calc(InputStream data, Collection<String> algos) throws IOException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, MessageDigest> digests = new LinkedHashMap<String, MessageDigest>();
        for (String string : algos) {
            try {
                digests.put(string, MessageDigest.getInstance(string));
            }
            catch (NoSuchAlgorithmException e) {
                results.put(string, e);
            }
        }
        Throwable throwable = null;
        try (InputStream in = data;){
            int read;
            byte[] buffer = new byte[32768];
            block12: while ((read = in.read(buffer)) >= 0) {
                Iterator iterator = digests.values().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block12;
                    MessageDigest digest = (MessageDigest)iterator.next();
                    digest.update(buffer, 0, read);
                }
                break;
            }
        }
        catch (Throwable buffer) {
            Throwable throwable2 = buffer;
            throw buffer;
        }
        for (Map.Entry entry : digests.entrySet()) {
            byte[] bytes = ((MessageDigest)entry.getValue()).digest();
            results.put((String)entry.getKey(), ChecksumUtils.toHexString(bytes));
        }
        return results;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b));
        }
        return buffer.toString();
    }

    public static byte[] fromHexString(String hexString) {
        if (hexString == null) {
            return null;
        }
        if (hexString.isEmpty()) {
            return new byte[0];
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexString length not even");
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

