/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.cache;

import java.util.regex.Pattern;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.ResolverLogger;

public class CacheParser {
    protected final ResolverLogger logger;
    private static final Pattern sizeK = Pattern.compile("^[0-9]+k$", 2);
    private static final Pattern sizeM = Pattern.compile("^[0-9]+m$", 2);
    private static final Pattern sizeG = Pattern.compile("^[0-9]+g$", 2);
    private static final Pattern timeS = Pattern.compile("^[0-9]+s$", 2);
    private static final Pattern timeM = sizeM;
    private static final Pattern timeH = Pattern.compile("^[0-9]+h$", 2);
    private static final Pattern timeD = Pattern.compile("^[0-9]+d$", 2);
    private static final Pattern timeW = Pattern.compile("^[0-9]+w$", 2);

    public CacheParser(ResolverConfiguration config) {
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public long parseLong(String longStr, long defVal) {
        if (longStr == null) {
            return defVal;
        }
        try {
            return Long.parseLong(longStr);
        }
        catch (NumberFormatException nfe) {
            this.logger.log("error", "Bad numeric value: %s", longStr);
            return defVal;
        }
    }

    public long parseSizeLong(String longStr, long defVal) {
        if (longStr == null) {
            return defVal;
        }
        long units = 1L;
        if (sizeK.matcher(longStr).matches()) {
            units = 1024L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (sizeM.matcher(longStr).matches()) {
            units = 1024000L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (sizeG.matcher(longStr).matches()) {
            units = 1024000000L;
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        return this.parseLong(longStr, units, defVal);
    }

    public long parseTimeLong(String longStr, long defVal) {
        if (longStr == null) {
            return defVal;
        }
        long units = 1L;
        if (timeS.matcher(longStr).matches()) {
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (timeM.matcher(longStr).matches()) {
            units = 60L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (timeH.matcher(longStr).matches()) {
            units = 3600L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (timeD.matcher(longStr).matches()) {
            units = 86400L;
            longStr = longStr.substring(0, longStr.length() - 1);
        } else if (timeW.matcher(longStr).matches()) {
            units = 604800L;
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        return this.parseLong(longStr, units, defVal);
    }

    public long parseLong(String longStr, long units, long defVal) {
        try {
            long val = Long.parseLong(longStr);
            return val * units;
        }
        catch (NumberFormatException nfe) {
            this.logger.log("error", "Bad numeric value: %s", longStr);
            return defVal;
        }
    }
}

