/*
 * Decompiled with CFR 0.152.
 */
package jodd.crypt;

import jodd.crypt.PBKDF2Encryptor;
import jodd.crypt.Threefish;
import jodd.util.StringUtil;

public interface CryptoEngine {
    public static CryptoEngine pbe3des(String password) {
        final PBKDF2Encryptor PBKDF2Encryptor2 = new PBKDF2Encryptor(password);
        return new CryptoEngine(){

            @Override
            public byte[] encryptString(String input) {
                return PBKDF2Encryptor2.encrypt(StringUtil.getBytes(input));
            }

            @Override
            public String decryptString(byte[] encryptedContent) {
                return StringUtil.newString(PBKDF2Encryptor2.decrypt(encryptedContent));
            }
        };
    }

    public static CryptoEngine threefish(String password) {
        final Threefish threefish = new Threefish(512);
        threefish.init(password, 1234605616436508552L, -71777215708423885L);
        return new CryptoEngine(){

            @Override
            public byte[] encryptString(String input) {
                return threefish.encryptString(input);
            }

            @Override
            public String decryptString(byte[] encryptedContent) {
                return threefish.decryptString(encryptedContent);
            }
        };
    }

    public byte[] encryptString(String var1);

    public String decryptString(byte[] var1);
}

