/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public final class ArrowButton
implements SwingConstants {
    private ArrowButton() {
    }

    public static JButton createUpDownArrow(JComponent parent, int orientation, boolean center) {
        return ArrowButton.createUpDownArrow(parent, orientation, center, false, new Insets(0, 0, 0, 0));
    }

    public static JButton createUpDownArrow(JComponent parent, int orientation, boolean center, boolean applyInsetsOnSize, Insets insets) {
        Icon icon;
        switch (orientation) {
            case 1: {
                icon = UIManager.getIcon("ArrowButton.up.icon");
                break;
            }
            case 5: {
                icon = UIManager.getIcon("ArrowButton.down.icon");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid button orientation: " + orientation);
            }
        }
        return ArrowButton.createUpDownArrow(parent, icon, icon, orientation, center, applyInsetsOnSize, insets);
    }

    public static JButton createUpDownArrow(final JComponent parent, final Icon activeIcon, final Icon inactiveIcon, int orientation, final boolean center, final boolean applyInsetsOnSize, final Insets insets) {
        return new BasicArrowButton(orientation, null, null, null, null){
            private final Insets ins;
            {
                super(direction, background, shadow, darkShadow, highlight);
                this.ins = insets != null ? insets : new Insets(0, 0, 0, 0);
                this.putClientProperty("JButton.noBorderlessOverwrite", true);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorder(BorderFactory.createEmptyBorder());
            }

            @Override
            public void paint(Graphics g) {
                Insets margin = this.getMargin();
                int w = this.getWidth() - margin.left - margin.right;
                int h = this.getHeight() - margin.top - margin.bottom;
                int x = margin.left + (w - this.getIcon().getIconWidth()) / 2;
                int y = center ? (h - this.getIcon().getIconHeight()) / 2 : (this.direction == 1 ? h - this.getIcon().getIconHeight() + 4 : -4);
                this.paintTriangle(g, x, y += margin.top, 0, this.direction, parent.isEnabled());
            }

            @Override
            public Icon getIcon() {
                return this.isEnabled() ? activeIcon : inactiveIcon;
            }

            @Override
            public Dimension getPreferredSize() {
                if (!applyInsetsOnSize) {
                    return new DimensionUIResource(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
                }
                Insets i = this.getInsets();
                return new DimensionUIResource(this.getIcon().getIconWidth() + i.left + i.right, this.getIcon().getIconHeight() + i.top + i.bottom);
            }

            @Override
            public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
                this.getIcon().paintIcon(this, g, x, y);
            }

            @Override
            public Insets getInsets() {
                return this.getInsets(new Insets(0, 0, 0, 0));
            }

            @Override
            public Insets getInsets(Insets i) {
                i.left = this.ins.left;
                i.right = this.ins.right;
                i.top = this.ins.top;
                i.bottom = this.ins.bottom;
                return i;
            }

            @Override
            public boolean isOpaque() {
                return false;
            }
        };
    }
}

