/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.sparql.syntax;

import org.apache.jena.sparql.util.NodeIsomorphismMap;

/** The syntax element for "Not Exists" in a pattern. */

public class ElementNotExists extends Element1 {
    public ElementNotExists(Element el) {
        super(el);
    }

    @Override
    public int hashCode() {
        return getElement().hashCode() ^ Element.HashNotExists;
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if ( el2 == null )
            return false;

        if ( !(el2 instanceof ElementNotExists) )
            return false;
        ElementNotExists eltNotExists = (ElementNotExists)el2;
        if ( !this.getElement().equalTo(eltNotExists.getElement(), isoMap) )
            return false;
        return true;
    }

    @Override
    public void visit(ElementVisitor v) { v.visit(this); }
}
