/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.GetProfileResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class GetProfileRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GetProfileRequest> {
    @Nonnull
    private final List<String> modelIds;
    @Nonnull
    private final List<String> nodeIds;
    @Nullable
    private final Boolean returnAllModels;
    @Nullable
    private final Boolean returnAllTasks;
    @Nonnull
    private final List<String> taskIds;
    public static final JsonpDeserializer<GetProfileRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetProfileRequest::setupGetProfileRequestDeserializer);
    public static final Endpoint<GetProfileRequest, GetProfileResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetProfileRequest, GetProfileResponse>(request -> "GET", request -> "/_plugins/_ml/profile", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetProfileResponse._DESERIALIZER);

    private GetProfileRequest(Builder builder) {
        super(builder);
        this.modelIds = ApiTypeHelper.unmodifiable(builder.modelIds);
        this.nodeIds = ApiTypeHelper.unmodifiable(builder.nodeIds);
        this.returnAllModels = builder.returnAllModels;
        this.returnAllTasks = builder.returnAllTasks;
        this.taskIds = ApiTypeHelper.unmodifiable(builder.taskIds);
    }

    public static GetProfileRequest of(Function<Builder, ObjectBuilder<GetProfileRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> modelIds() {
        return this.modelIds;
    }

    @Nonnull
    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Nullable
    public final Boolean returnAllModels() {
        return this.returnAllModels;
    }

    @Nullable
    public final Boolean returnAllTasks() {
        return this.returnAllTasks;
    }

    @Nonnull
    public final List<String> taskIds() {
        return this.taskIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.modelIds)) {
            generator.writeKey("model_ids");
            generator.writeStartArray();
            for (String item0 : this.modelIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodeIds)) {
            generator.writeKey("node_ids");
            generator.writeStartArray();
            for (String item0 : this.nodeIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.returnAllModels != null) {
            generator.writeKey("return_all_models");
            generator.write(this.returnAllModels.booleanValue());
        }
        if (this.returnAllTasks != null) {
            generator.writeKey("return_all_tasks");
            generator.write(this.returnAllTasks.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.taskIds)) {
            generator.writeKey("task_ids");
            generator.writeStartArray();
            for (String item0 : this.taskIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetProfileRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "model_ids");
        op.add(Builder::nodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node_ids");
        op.add(Builder::returnAllModels, JsonpDeserializer.booleanDeserializer(), "return_all_models");
        op.add(Builder::returnAllTasks, JsonpDeserializer.booleanDeserializer(), "return_all_tasks");
        op.add(Builder::taskIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "task_ids");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.modelIds);
        result = 31 * result + Objects.hashCode(this.nodeIds);
        result = 31 * result + Objects.hashCode(this.returnAllModels);
        result = 31 * result + Objects.hashCode(this.returnAllTasks);
        result = 31 * result + Objects.hashCode(this.taskIds);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetProfileRequest other = (GetProfileRequest)o;
        return Objects.equals(this.modelIds, other.modelIds) && Objects.equals(this.nodeIds, other.nodeIds) && Objects.equals(this.returnAllModels, other.returnAllModels) && Objects.equals(this.returnAllTasks, other.returnAllTasks) && Objects.equals(this.taskIds, other.taskIds);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetProfileRequest> {
        @Nullable
        private List<String> modelIds;
        @Nullable
        private List<String> nodeIds;
        @Nullable
        private Boolean returnAllModels;
        @Nullable
        private Boolean returnAllTasks;
        @Nullable
        private List<String> taskIds;

        public Builder() {
        }

        private Builder(GetProfileRequest o) {
            super(o);
            this.modelIds = Builder._listCopy(o.modelIds);
            this.nodeIds = Builder._listCopy(o.nodeIds);
            this.returnAllModels = o.returnAllModels;
            this.returnAllTasks = o.returnAllTasks;
            this.taskIds = Builder._listCopy(o.taskIds);
        }

        private Builder(Builder o) {
            super(o);
            this.modelIds = Builder._listCopy(o.modelIds);
            this.nodeIds = Builder._listCopy(o.nodeIds);
            this.returnAllModels = o.returnAllModels;
            this.returnAllTasks = o.returnAllTasks;
            this.taskIds = Builder._listCopy(o.taskIds);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder modelIds(List<String> list) {
            this.modelIds = Builder._listAddAll(this.modelIds, list);
            return this;
        }

        @Nonnull
        public final Builder modelIds(String value, String ... values) {
            this.modelIds = Builder._listAdd(this.modelIds, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeIds(List<String> list) {
            this.nodeIds = Builder._listAddAll(this.nodeIds, list);
            return this;
        }

        @Nonnull
        public final Builder nodeIds(String value, String ... values) {
            this.nodeIds = Builder._listAdd(this.nodeIds, value, values);
            return this;
        }

        @Nonnull
        public final Builder returnAllModels(@Nullable Boolean value) {
            this.returnAllModels = value;
            return this;
        }

        @Nonnull
        public final Builder returnAllTasks(@Nullable Boolean value) {
            this.returnAllTasks = value;
            return this;
        }

        @Nonnull
        public final Builder taskIds(List<String> list) {
            this.taskIds = Builder._listAddAll(this.taskIds, list);
            return this;
        }

        @Nonnull
        public final Builder taskIds(String value, String ... values) {
            this.taskIds = Builder._listAdd(this.taskIds, value, values);
            return this;
        }

        @Override
        @Nonnull
        public GetProfileRequest build() {
            this._checkSingleUse();
            return new GetProfileRequest(this);
        }
    }
}

