/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.webadmin.utils.JsonTransformerModule;

public class MappingsModule
implements JsonTransformerModule {
    private final SimpleModule simpleModule = new SimpleModule().addSerializer(MappingSource.class, (JsonSerializer)new MappingSourceSerializer()).addDeserializer(MappingSource.class, (JsonDeserializer)new MappingSourceDeserializer()).addKeySerializer(MappingSource.class, (JsonSerializer)new MappingSourceKeySerializer()).addKeyDeserializer(MappingSource.class, (KeyDeserializer)new MappingSourceKeyDeserializer()).addSerializer(Mapping.class, (JsonSerializer)new MappingSerializer()).addDeserializer(Mapping.class, (JsonDeserializer)new MappingDeserializer()).addSerializer(Mappings.class, (JsonSerializer)new MappingsSerializer()).addDeserializer(Mappings.class, (JsonDeserializer)new MappingsDeserializer());

    public Module asJacksonModule() {
        return this.simpleModule;
    }

    private static class MappingSourceSerializer
    extends JsonSerializer<MappingSource> {
        private MappingSourceSerializer() {
        }

        public void serialize(MappingSource mappingSource, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(mappingSource.asString());
        }
    }

    private static class MappingSourceDeserializer
    extends JsonDeserializer<MappingSource> {
        private MappingSourceDeserializer() {
        }

        public MappingSource deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return MappingSource.parse((String)jsonParser.getText());
        }
    }

    private static class MappingSourceKeySerializer
    extends JsonSerializer<MappingSource> {
        private MappingSourceKeySerializer() {
        }

        public void serialize(MappingSource mappingSource, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeFieldName(mappingSource.asString());
        }
    }

    private static class MappingSourceKeyDeserializer
    extends KeyDeserializer {
        private MappingSourceKeyDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext deserializationContext) throws IOException {
            return MappingSource.parse((String)key);
        }
    }

    private static class MappingSerializer
    extends JsonSerializer<Mapping> {
        private MappingSerializer() {
        }

        public void serialize(Mapping mapping, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", mapping.getType().toString());
            jsonGenerator.writeStringField("mapping", mapping.getMappingValue());
            jsonGenerator.writeEndObject();
        }
    }

    private static class MappingDeserializer
    extends JsonDeserializer<Mapping> {
        private MappingDeserializer() {
        }

        public Mapping deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            String type = node.get("type").asText();
            String mapping = node.get("mapping").asText();
            return Mapping.of((Mapping.Type)Mapping.Type.valueOf((String)type), (String)mapping);
        }
    }

    private static class MappingsSerializer
    extends JsonSerializer<Mappings> {
        private MappingsSerializer() {
        }

        public void serialize(Mappings mappings, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartArray();
            for (Mapping mapping : mappings) {
                jsonGenerator.writeObject((Object)mapping);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private static class MappingsDeserializer
    extends JsonDeserializer<Mappings> {
        private MappingsDeserializer() {
        }

        public Mappings deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
            List items = (List)mapper.readValue(jsonParser, (TypeReference)new TypeReference<List<Mapping>>(this){});
            return MappingsImpl.fromMappings(items.stream());
        }
    }
}

