/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.identity;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.HtmlSignature$;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.Identity$;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.api.model.TextSignature$;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005A4Aa\u0002\u0005\u0001+!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0007\u0001\"\u0003h\u0005]!UMZ1vYRLE-\u001a8uSRL8+\u001e9qY&,'O\u0003\u0002\n\u0015\u0005A\u0011\u000eZ3oi&$\u0018P\u0003\u0002\f\u0019\u0005\u0019\u0011\r]5\u000b\u00055q\u0011\u0001\u00026nCBT!a\u0004\t\u0002\u000b)\fW.Z:\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\fG\u0006t7+\u001a8e\rJ|W\u000e\u0005\u0002\u001fE5\tqD\u0003\u0002\fA)\u0011\u0011ED\u0001\u0004eJ$\u0018BA\u0012 \u0005-\u0019\u0015M\\*f]\u00124%o\\7\u0002\u001fU\u001cXM]:SKB|7/\u001b;pef\u0004\"A\n\u0016\u000e\u0003\u001dR!a\u0003\u0015\u000b\u0005%r\u0011\u0001B;tKJL!aK\u0014\u0003\u001fU\u001bXM]:SKB|7/\u001b;pef\fa\u0001P5oSRtDc\u0001\u00181cA\u0011q\u0006A\u0007\u0002\u0011!)Ad\u0001a\u0001;!)Ae\u0001a\u0001K!\u00121a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\na!\u001b8kK\u000e$(\"\u0001\u001d\u0002\u000f)\f7.\u0019:uC&\u0011!(\u000e\u0002\u0007\u0013:TWm\u0019;\u0002\u001d1L7\u000f^%eK:$\u0018\u000e^5fgR\u0011Q(\u0013\t\u0004}\u0005\u001bU\"A \u000b\u0005\u0001\u0013\u0012a\u0004:fC\u000e$\u0018N^3tiJ,\u0017-\\:\n\u0005\t{$!\u0003)vE2L7\u000f[3s!\t!u)D\u0001F\u0015\t1%\"A\u0003n_\u0012,G.\u0003\u0002I\u000b\nA\u0011\nZ3oi&$\u0018\u0010C\u0003K\t\u0001\u00071*\u0001\u0005vg\u0016\u0014h.Y7f!\tau*D\u0001N\u0015\tqe\"\u0001\u0003d_J,\u0017B\u0001)N\u0005!)6/\u001a:oC6,\u0017aD;tKJ\u001c\u0015M\\*f]\u00124%o\\7\u0015\u0007M\u0003\u0017\rE\u0002U7vk\u0011!\u0016\u0006\u0003-^\u000b\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005eA&B\u0001(Z\u0015\u0005Q\u0016a\u0002:fC\u000e$xN]\u0005\u00039V\u0013QaU'p]>\u0004\"a\u00060\n\u0005}C\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0005\u0006E\u0016\u0001\raY\u0001\f[\u0006LG.\u00113ee\u0016\u001c8\u000f\u0005\u0002MI&\u0011Q-\u0014\u0002\f\u001b\u0006LG.\u00113ee\u0016\u001c8/\u0001\u0003ge>lGC\u00015o!\r9\u0012n[\u0005\u0003Ub\u0011aa\u00149uS>t\u0007C\u0001#m\u0013\tiWI\u0001\u0006JI\u0016tG/\u001b;z\u0013\u0012DQa\u001c\u0004A\u0002\r\fq!\u00193ee\u0016\u001c8\u000f")
public class DefaultIdentitySupplier {
    private final CanSendFrom canSendFrom;
    private final UsersRepository usersRepository;

    public Publisher<Identity> listIdentities(Username username) {
        SFlux qual$1 = SFlux$.MODULE$.apply(this.canSendFrom.allValidFromAddressesForUser(username)).map((Function1 & Serializable)address -> this.from((MailAddress)address).map((Function1 & Serializable)id -> {
            IdentityId x$1 = id;
            String x$2 = address.asString();
            MailAddress x$3 = address;
            None$ x$4 = None$.MODULE$;
            None$ x$5 = None$.MODULE$;
            String x$6 = TextSignature$.MODULE$.DEFAULT();
            String x$7 = HtmlSignature$.MODULE$.DEFAULT();
            boolean x$8 = false;
            int x$9 = Identity$.MODULE$.DEFAULT_SORTORDER();
            return new Identity(x$1, x$9, x$2, x$3, (Option<List<EmailAddress>>)x$4, (Option<List<EmailAddress>>)x$5, x$6, x$7, x$8);
        }));
        Function1 & Serializable x$10 = (Function1 & Serializable)option -> (SMono)option.map((Function1 & Serializable)data -> SMono$.MODULE$.just(data)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
        int x$11 = qual$1.flatMap$default$2();
        int x$12 = qual$1.flatMap$default$3();
        boolean x$13 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$10, x$11, x$12, x$13);
    }

    public SMono<Object> userCanSendFrom(Username username, MailAddress mailAddress) {
        return SMono$.MODULE$.fromPublisher(this.canSendFrom.userCanSendFromReactive(username, this.usersRepository.getUsername(mailAddress))).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Boolean2boolean(x$18)))));
    }

    private Option<IdentityId> from(MailAddress address) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> UUID.nameUUIDFromBytes(address.asString().getBytes(StandardCharsets.UTF_8))).toEither().toOption().map((Function1 & Serializable)x$19 -> new IdentityId((UUID)x$19));
    }

    @Inject
    public DefaultIdentitySupplier(CanSendFrom canSendFrom, UsersRepository usersRepository) {
        this.canSendFrom = canSendFrom;
        this.usersRepository = usersRepository;
    }
}

