/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.query;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.opensearch.query.CriterionConverter;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermsQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsQueryField;

public class QueryConverter {
    private final CriterionConverter criterionConverter;

    @Inject
    public QueryConverter(CriterionConverter criterionConverter) {
        this.criterionConverter = criterionConverter;
    }

    public Query from(Collection<MailboxId> mailboxIds, SearchQuery query) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder().must(this.generateQueryBuilder(query), new Query[0]);
        this.mailboxesQuery(mailboxIds).map(x$0 -> boolQueryBuilder.filter(x$0, new Query[0]));
        return boolQueryBuilder.build().toQuery();
    }

    private Query generateQueryBuilder(SearchQuery searchQuery) {
        List criteria = searchQuery.getCriteria();
        if (criteria.isEmpty()) {
            return this.criterionConverter.convertCriterion(SearchQuery.all());
        }
        if (criteria.size() == 1) {
            return this.criterionConverter.convertCriterion((SearchQuery.Criterion)criteria.get(0));
        }
        return this.criterionConverter.convertCriterion((SearchQuery.Criterion)new SearchQuery.ConjunctionCriterion(SearchQuery.Conjunction.AND, criteria));
    }

    private Optional<Query> mailboxesQuery(Collection<MailboxId> mailboxIds) {
        if (mailboxIds.isEmpty()) {
            return Optional.empty();
        }
        ImmutableList ids = (ImmutableList)mailboxIds.stream().map(MailboxId::serialize).map(id -> (FieldValue)new FieldValue.Builder().stringValue(id).build()).collect(ImmutableList.toImmutableList());
        return Optional.of(new TermsQuery.Builder().field("mailboxId").terms((TermsQueryField)new TermsQueryField.Builder().value((List)ids).build()).build().toQuery());
    }
}

