/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import org.apache.james.transport.mailets.MappingArgument;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class MailAttributesToMimeHeaders
extends GenericMailet {
    private ImmutableMap<AttributeName, String> mappings;

    public void init() throws MessagingException {
        String simpleMappings = this.getInitParameter("simplemapping");
        if (Strings.isNullOrEmpty((String)simpleMappings)) {
            throw new MessagingException("simplemapping is required");
        }
        this.mappings = (ImmutableMap)MappingArgument.parse(simpleMappings).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> AttributeName.of((String)((String)entry.getKey())), Map.Entry::getValue));
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        this.mappings.entrySet().stream().forEach(entry -> this.addHeader((Map.Entry<AttributeName, String>)entry, mail, message));
        message.saveChanges();
    }

    private void addHeader(Map.Entry<AttributeName, String> entry, Mail mail, MimeMessage message) {
        AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)entry.getKey(), String.class).ifPresent(Throwing.consumer(value -> {
            String headerName = (String)entry.getValue();
            message.addHeader(headerName, value);
        }).sneakyThrow());
    }
}

