/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import jakarta.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.SetQuotaRequest;

public class SetQuotaCommandParser
extends AbstractImapCommandParser {
    @Inject
    public SetQuotaCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.SETQUOTA_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String quotaRoot = request.atom();
        SetQuotaRequest setQuotaRequest = new SetQuotaRequest(tag, quotaRoot);
        request.nextWordChar();
        while (request.nextChar() == '(') {
            request.consume();
            String resource = request.atom();
            request.nextWordChar();
            long limit = request.number(true);
            request.nextWordChar();
            request.consumeChar(')');
            setQuotaRequest.addResourceLimit(resource, limit);
            while (request.nextChar() == ' ') {
                request.consume();
            }
        }
        request.eol();
        return setQuotaRequest;
    }
}

