/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.github.fge.lambdas.Throwing;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.Set;
import org.apache.james.task.Task;
import org.apache.james.task.TaskType;
import org.apache.james.util.Runnables;
import reactor.core.publisher.Flux;

public class CleanupTasksPerformer {
    private final Set<CleanupTask> cleanupTasks;

    @Inject
    public CleanupTasksPerformer(Set<CleanupTask> cleanupTasks) {
        this.cleanupTasks = cleanupTasks;
    }

    @PreDestroy
    public void clean() {
        Runnables.runParallel((Flux)Flux.fromIterable(this.cleanupTasks).map(cleanupTask -> Throwing.runnable(() -> ((CleanupTask)cleanupTask).run()).sneakyThrow()));
    }

    public static interface CleanupTask
    extends Task {
        default public TaskType type() {
            return TaskType.of((String)"cleanup-task");
        }
    }
}

