/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Username;

public class MailboxSession {
    public static long SYSTEM_SESSION_ID = 0L;
    private final Collection<String> sharedSpaces;
    private final String otherUsersSpace;
    private final String personalSpace;
    private final SessionId sessionId;
    private final Username userName;
    private final Optional<Username> loggedInUser;
    private final List<Locale> localePreferences;
    private final Map<Object, Object> attributes;
    private final char pathSeparator;
    private final SessionType type;

    public static boolean isPrimaryAccount(MailboxSession mailboxSession) {
        return mailboxSession.loggedInUser.map(loggedInUser -> loggedInUser.equals(mailboxSession.getUser())).orElse(false);
    }

    public MailboxSession(SessionId sessionId, Username userName, Optional<Username> loggedInUser, List<Locale> localePreferences, char pathSeparator, SessionType type) {
        this(sessionId, userName, loggedInUser, localePreferences, new ArrayList<String>(), null, pathSeparator, type);
    }

    public MailboxSession(SessionId sessionId, Username userName, Optional<Username> loggedInUser, List<Locale> localePreferences, List<String> sharedSpaces, String otherUsersSpace, char pathSeparator, SessionType type) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.otherUsersSpace = otherUsersSpace;
        this.sharedSpaces = sharedSpaces;
        this.type = type;
        this.personalSpace = otherUsersSpace == null && (sharedSpaces == null || sharedSpaces.isEmpty()) ? "" : "#private";
        this.localePreferences = localePreferences;
        this.attributes = new HashMap<Object, Object>();
        this.pathSeparator = pathSeparator;
        this.loggedInUser = loggedInUser;
    }

    public SessionType getType() {
        return this.type;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public Username getUser() {
        return this.userName;
    }

    public Optional<Username> getLoggedInUser() {
        return this.loggedInUser;
    }

    public List<Locale> getLocalePreferences() {
        return this.localePreferences;
    }

    public String getPersonalSpace() {
        return this.personalSpace;
    }

    public String getOtherUsersSpace() {
        return this.otherUsersSpace;
    }

    public Collection<String> getSharedSpaces() {
        return this.sharedSpaces;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public char getPathDelimiter() {
        return this.pathSeparator;
    }

    public String toString() {
        String tab = " ";
        return "MailboxSession ( sessionId = " + String.valueOf(this.sessionId) + " )";
    }

    public static class SessionId {
        private final long sessionId;

        public static SessionId of(long sessionId) {
            return new SessionId(sessionId);
        }

        private SessionId(long sessionId) {
            this.sessionId = sessionId;
        }

        public long getValue() {
            return this.sessionId;
        }

        public final boolean equals(Object o) {
            if (o instanceof SessionId) {
                SessionId that = (SessionId)o;
                return Objects.equals(this.sessionId, that.sessionId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.sessionId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sessionId", this.sessionId).toString();
        }
    }

    public static enum SessionType {
        System,
        User;

    }
}

