/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.token.credentials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class SdkTokenProviderChain
implements SdkTokenProvider,
SdkAutoCloseable {
    private static final Logger log = Logger.loggerFor(SdkTokenProviderChain.class);
    private final List<SdkTokenProvider> sdkTokenProviders;
    private final boolean reuseLastProviderEnabled;
    private volatile SdkTokenProvider lastUsedProvider;

    private SdkTokenProviderChain(BuilderImpl builder) {
        Validate.notEmpty((Collection)builder.tokenProviders, (String)"No token providers were specified.", (Object[])new Object[0]);
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.sdkTokenProviders = Collections.unmodifiableList(builder.tokenProviders);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static SdkTokenProviderChain of(SdkTokenProvider ... sdkTokenProviders) {
        return SdkTokenProviderChain.builder().tokenProviders(sdkTokenProviders).build();
    }

    @Override
    public SdkToken resolveToken() {
        if (this.reuseLastProviderEnabled && this.lastUsedProvider != null) {
            return this.lastUsedProvider.resolveToken();
        }
        ArrayList<String> exceptionMessages = null;
        for (SdkTokenProvider provider : this.sdkTokenProviders) {
            try {
                SdkToken token = provider.resolveToken();
                log.debug(() -> "Loading token from " + provider);
                this.lastUsedProvider = provider;
                return token;
            }
            catch (RuntimeException e) {
                String message = provider + ": " + e.getMessage();
                log.debug(() -> "Unable to load token from " + message, (Throwable)e);
                if (exceptionMessages == null) {
                    exceptionMessages = new ArrayList<String>();
                }
                exceptionMessages.add(message);
            }
        }
        throw SdkClientException.builder().message("Unable to load token from any of the providers in the chain " + this + " : " + exceptionMessages).build();
    }

    public void close() {
        this.sdkTokenProviders.forEach(c -> IoUtils.closeIfCloseable((Object)c, null));
    }

    public String toString() {
        return ToString.builder((String)"AwsTokenProviderChain").add("tokenProviders", this.sdkTokenProviders).build();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean reuseLastProviderEnabled = true;
        private List<SdkTokenProvider> tokenProviders = new ArrayList<SdkTokenProvider>();

        private BuilderImpl() {
        }

        @Override
        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public void setReuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled(reuseLastProviderEnabled);
        }

        @Override
        public Builder tokenProviders(Collection<? extends SdkTokenProvider> tokenProviders) {
            this.tokenProviders = new ArrayList<SdkTokenProvider>(tokenProviders);
            return this;
        }

        public void setTokenProviders(Collection<? extends SdkTokenProvider> tokenProviders) {
            this.tokenProviders(tokenProviders);
        }

        @Override
        public Builder tokenProviders(SdkTokenProvider ... tokenProviders) {
            return this.tokenProviders(Arrays.asList(tokenProviders));
        }

        @Override
        public Builder addTokenProvider(SdkTokenProvider tokenProviders) {
            this.tokenProviders.add(tokenProviders);
            return this;
        }

        @Override
        public SdkTokenProviderChain build() {
            return new SdkTokenProviderChain(this);
        }
    }

    public static interface Builder {
        public Builder reuseLastProviderEnabled(Boolean var1);

        public Builder tokenProviders(Collection<? extends SdkTokenProvider> var1);

        public Builder tokenProviders(SdkTokenProvider ... var1);

        public Builder addTokenProvider(SdkTokenProvider var1);

        public SdkTokenProviderChain build();
    }
}

