/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableList;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Delivery;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.backends.rabbitmq.QueueArguments;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.KeyRegistration;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.LocalListenerRegistry;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationBinder;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RegistrationQueueName;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.RoutingKeyConverter;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.StructuredLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.ConsumeOptions;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;
import reactor.util.retry.Retry;

class KeyRegistrationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyRegistrationHandler.class);
    private static final Duration EXPIRATION_TIMEOUT = Duration.ofMinutes(30L);
    private static final Duration TOPOLOGY_CHANGES_TIMEOUT = Duration.ofMinutes(1L);
    private final EventBusId eventBusId;
    private final LocalListenerRegistry localListenerRegistry;
    private final EventSerializer eventSerializer;
    private final Sender sender;
    private final RoutingKeyConverter routingKeyConverter;
    private final RegistrationQueueName registrationQueue;
    private final RegistrationBinder registrationBinder;
    private final ListenerExecutor listenerExecutor;
    private final RetryBackoffConfiguration retryBackoff;
    private final RabbitMQConfiguration configuration;
    private final ReceiverProvider receiverProvider;
    private Optional<Disposable> receiverSubscriber;
    private final MetricFactory metricFactory;
    private Scheduler scheduler;
    private Disposable newSubscription;

    KeyRegistrationHandler(NamingStrategy namingStrategy, EventBusId eventBusId, EventSerializer eventSerializer, Sender sender, ReceiverProvider receiverProvider, RoutingKeyConverter routingKeyConverter, LocalListenerRegistry localListenerRegistry, ListenerExecutor listenerExecutor, RetryBackoffConfiguration retryBackoff, RabbitMQConfiguration configuration, MetricFactory metricFactory) {
        this.eventBusId = eventBusId;
        this.eventSerializer = eventSerializer;
        this.sender = sender;
        this.routingKeyConverter = routingKeyConverter;
        this.localListenerRegistry = localListenerRegistry;
        this.receiverProvider = receiverProvider;
        this.listenerExecutor = listenerExecutor;
        this.retryBackoff = retryBackoff;
        this.configuration = configuration;
        this.metricFactory = metricFactory;
        this.registrationQueue = namingStrategy.queueName(eventBusId);
        this.registrationBinder = new RegistrationBinder(namingStrategy, sender, this.registrationQueue);
        this.receiverSubscriber = Optional.empty();
    }

    void start() {
        this.scheduler = Schedulers.newBoundedElastic((int)10, (int)ReactorUtils.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"keys-handler");
        this.declareQueue();
        this.newSubscription = Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeAutoAck(this.registrationQueue.asString(), new ConsumeOptions().qos(10)), Receiver::close).flatMap(this::handleDelivery, 10).subscribeOn(this.scheduler).subscribe();
        this.receiverSubscriber = Optional.of(this.newSubscription);
    }

    void restart() {
        Optional<Disposable> previousReceiverSubscriber = this.receiverSubscriber;
        this.receiverSubscriber = Optional.of(this.newSubscription);
        previousReceiverSubscriber.filter(Predicate.not(Disposable::isDisposed)).ifPresent(Disposable::dispose);
    }

    void declareQueue() {
        this.declareQueue(this.sender);
    }

    private void declareQueue(Sender sender) {
        QueueArguments.Builder builder = this.configuration.workQueueArgumentsBuilder(false);
        this.configuration.getQueueTTL().ifPresent(arg_0 -> ((QueueArguments.Builder)builder).queueTTL(arg_0));
        sender.declareQueue(QueueSpecification.queue((String)this.registrationQueue.asString()).durable(this.configuration.isEventBusNotificationDurabilityEnabled()).exclusive(false).autoDelete(true).arguments((Map)builder.build())).timeout(TOPOLOGY_CHANGES_TIMEOUT).map(AMQP.Queue.DeclareOk::getQueue).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor())).block();
    }

    void stop() {
        this.sender.delete(QueueSpecification.queue((String)this.registrationQueue.asString())).timeout(TOPOLOGY_CHANGES_TIMEOUT).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor()).scheduler(Schedulers.parallel())).block();
        this.receiverSubscriber.filter(Predicate.not(Disposable::isDisposed)).ifPresent(Disposable::dispose);
        Optional.ofNullable(this.scheduler).ifPresent(Scheduler::dispose);
    }

    Mono<Registration> register(EventListener.ReactiveEventListener listener, RegistrationKey key) {
        LocalListenerRegistry.LocalRegistration registration = this.localListenerRegistry.addListener(key, listener);
        return this.registerIfNeeded(key, registration).thenReturn((Object)new KeyRegistration(() -> {
            if (registration.unregister().lastListenerRemoved()) {
                return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("rabbit-unregister", (Publisher)this.registrationBinder.unbind(key).timeout(TOPOLOGY_CHANGES_TIMEOUT).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor()).scheduler(Schedulers.boundedElastic())))).subscribeOn(Schedulers.boundedElastic());
            }
            return Mono.empty();
        }));
    }

    private Mono<Void> registerIfNeeded(RegistrationKey key, LocalListenerRegistry.LocalRegistration registration) {
        if (registration.isFirstListener()) {
            return this.registrationBinder.bind(key).subscribeOn(Schedulers.boundedElastic()).timeout(TOPOLOGY_CHANGES_TIMEOUT).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor()).scheduler(Schedulers.boundedElastic()));
        }
        return Mono.empty();
    }

    private Mono<Void> handleDelivery(Delivery delivery) {
        if (delivery.getBody() == null) {
            return Mono.empty();
        }
        String serializedEventBusId = delivery.getProperties().getHeaders().get("eventBusId").toString();
        EventBusId eventBusId = EventBusId.of(serializedEventBusId);
        String routingKey = delivery.getEnvelope().getRoutingKey();
        RegistrationKey registrationKey = this.routingKeyConverter.toRegistrationKey(routingKey);
        List listenersToCall = (List)this.localListenerRegistry.getLocalListeners(registrationKey).stream().filter(listener -> !this.isLocalSynchronousListeners(eventBusId, (EventListener)listener)).collect(ImmutableList.toImmutableList());
        if (listenersToCall.isEmpty()) {
            return Mono.empty();
        }
        Event event = this.toEvent(delivery);
        return Flux.fromIterable((Iterable)listenersToCall).flatMap(listener -> this.executeListener((EventListener.ReactiveEventListener)listener, event, registrationKey), 10).then();
    }

    private Mono<Void> executeListener(EventListener.ReactiveEventListener listener, Event event, RegistrationKey key) {
        MDCBuilder mdcBuilder = MDCBuilder.create().addToContext("registrationKey", key.asString());
        return this.listenerExecutor.execute(listener, mdcBuilder, event).doOnError(e -> this.structuredLogger(event, key).log(logger -> logger.error("Exception happens when handling event", e))).onErrorResume(e -> Mono.empty()).then();
    }

    private boolean isLocalSynchronousListeners(EventBusId eventBusId, EventListener listener) {
        return eventBusId.equals(this.eventBusId) && listener.getExecutionMode().equals((Object)EventListener.ExecutionMode.SYNCHRONOUS);
    }

    private Event toEvent(Delivery delivery) {
        return this.eventSerializer.fromBytes(delivery.getBody());
    }

    private StructuredLogger structuredLogger(Event event, RegistrationKey key) {
        return MDCStructuredLogger.forLogger((Logger)LOGGER).field("eventId", event.getEventId().getId().toString()).field("eventClass", event.getClass().getCanonicalName()).field("user", event.getUsername().asString()).field("registrationKey", key.asString());
    }
}

