/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaValue;

public class QuotaSize
implements QuotaValue<QuotaSize> {
    public static final QuotaSize QUOTA_SIZE = new QuotaSize(Optional.empty());
    private final Optional<Long> value;

    public static QuotaSize unlimited() {
        return QUOTA_SIZE;
    }

    public static QuotaSize size(long value) {
        return QuotaSize.size(Optional.of(value));
    }

    public static QuotaSize size(Optional<Long> value) {
        return new QuotaSize(value);
    }

    private QuotaSize(Optional<Long> value) {
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value.orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean isLimited() {
        return this.value.isPresent();
    }

    @Override
    public QuotaSize add(long additionalValue) {
        return new QuotaSize(this.value.map(x -> x + additionalValue));
    }

    @Override
    public QuotaSize add(QuotaSize additionalValue) {
        if (additionalValue.isUnlimited()) {
            return QuotaSize.unlimited();
        }
        return new QuotaSize(this.value.map(x -> x + additionalValue.asLong()));
    }

    @Override
    public boolean isGreaterThan(QuotaSize other) {
        return this.value.orElse(Long.MAX_VALUE) > other.value.orElse(Long.MAX_VALUE);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value.map(String::valueOf).orElse("unlimited")).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaSize) {
            QuotaSize that = (QuotaSize)o;
            return Objects.equal(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.value);
    }
}

