/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchEntryAccessLogMessage
extends SearchRequestAccessLogMessage {
    private static final long serialVersionUID = 6423635071693560277L;
    @Nullable
    private final List<String> attributesReturned;
    @NotNull
    private final List<String> responseControlOIDs;
    @Nullable
    private final String dn = this.getNamedValue("dn");

    public SearchEntryAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public SearchEntryAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        String attrs = this.getNamedValue("attrsReturned");
        if (attrs == null) {
            this.attributesReturned = null;
        } else {
            ArrayList<String> l = new ArrayList<String>(10);
            StringTokenizer tokenizer = new StringTokenizer(attrs, ",");
            while (tokenizer.hasMoreTokens()) {
                l.add(tokenizer.nextToken());
            }
            this.attributesReturned = Collections.unmodifiableList(l);
        }
    }

    @Nullable
    public String getDN() {
        return this.dn;
    }

    @Nullable
    public List<String> getAttributesReturned() {
        return this.attributesReturned;
    }

    @NotNull
    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY;
    }
}

