/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientResponseValue;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateClientResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String INTERMEDIATE_CLIENT_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.2";
    private static final long serialVersionUID = 7476073413872875835L;
    @NotNull
    private final IntermediateClientResponseValue value;

    IntermediateClientResponseControl() {
        this.value = null;
    }

    public IntermediateClientResponseControl(@Nullable IntermediateClientResponseValue upstreamResponse, @Nullable String upstreamServerAddress, @Nullable Boolean upstreamServerSecure, @Nullable String serverName, @Nullable String serverSessionID, @Nullable String serverResponseID) {
        this(false, new IntermediateClientResponseValue(upstreamResponse, upstreamServerAddress, upstreamServerSecure, serverName, serverSessionID, serverResponseID));
    }

    public IntermediateClientResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence valueSequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CONTROL_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICRESP_CONTROL_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.value = IntermediateClientResponseValue.decode(valueSequence);
    }

    public IntermediateClientResponseControl(@NotNull IntermediateClientResponseValue value) {
        this(false, value);
    }

    public IntermediateClientResponseControl(boolean isCritical, @NotNull IntermediateClientResponseValue value) {
        super(INTERMEDIATE_CLIENT_RESPONSE_OID, isCritical, new ASN1OctetString(value.encode().encode()));
        this.value = value;
    }

    @Override
    @NotNull
    public IntermediateClientResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new IntermediateClientResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static IntermediateClientResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(INTERMEDIATE_CLIENT_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof IntermediateClientResponseControl) {
            return (IntermediateClientResponseControl)c;
        }
        return new IntermediateClientResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public IntermediateClientResponseValue getResponseValue() {
        return this.value;
    }

    @Nullable
    public IntermediateClientResponseValue getUpstreamResponse() {
        return this.value.getUpstreamResponse();
    }

    @Nullable
    public String getUpstreamServerAddress() {
        return this.value.getUpstreamServerAddress();
    }

    @Nullable
    public Boolean upstreamServerSecure() {
        return this.value.upstreamServerSecure();
    }

    @Nullable
    public String getServerName() {
        return this.value.getServerName();
    }

    @Nullable
    public String getServerSessionID() {
        return this.value.getServerSessionID();
    }

    @Nullable
    public String getServerResponseID() {
        return this.value.getServerResponseID();
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_INTERMEDIATE_CLIENT_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IntermediateClientResponseControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", value=");
        this.value.toString(buffer);
        buffer.append(')');
    }
}

