/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.AlertSeverity;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AlertEntry
extends ReadOnlyEntry {
    @NotNull
    public static final String OC_ALERT = "ds-admin-alert";
    @NotNull
    public static final String ATTR_ALERT_GENERATOR = "ds-alert-generator";
    @NotNull
    public static final String ATTR_ALERT_ID = "ds-alert-id";
    @NotNull
    public static final String ATTR_ALERT_MESSAGE = "ds-alert-message";
    @NotNull
    public static final String ATTR_ALERT_SEVERITY = "ds-alert-severity";
    @NotNull
    public static final String ATTR_ALERT_TIME = "ds-alert-time";
    @NotNull
    public static final String ATTR_ALERT_TYPE = "ds-alert-type";
    @NotNull
    public static final String ATTR_ALERT_TYPE_OID = "ds-alert-type-oid";
    private static final long serialVersionUID = -2912778595612338699L;
    @Nullable
    private final AlertSeverity alertSeverity;
    @Nullable
    private final Date alertTime;
    @Nullable
    private final String alertGeneratorClass;
    @Nullable
    private final String alertID;
    @Nullable
    private final String alertMessage;
    @Nullable
    private final String alertType;
    @Nullable
    private final String alertTypeOID;

    public AlertEntry(@NotNull Entry entry) {
        super(entry);
        this.alertGeneratorClass = entry.getAttributeValue(ATTR_ALERT_GENERATOR);
        this.alertID = entry.getAttributeValue(ATTR_ALERT_ID);
        this.alertMessage = entry.getAttributeValue(ATTR_ALERT_MESSAGE);
        this.alertType = entry.getAttributeValue(ATTR_ALERT_TYPE);
        this.alertTypeOID = entry.getAttributeValue(ATTR_ALERT_TYPE_OID);
        this.alertTime = entry.getAttributeValueAsDate(ATTR_ALERT_TIME);
        String severityStr = entry.getAttributeValue(ATTR_ALERT_SEVERITY);
        this.alertSeverity = severityStr == null ? null : AlertSeverity.forName(severityStr);
    }

    @Nullable
    public String getAlertGeneratorClass() {
        return this.alertGeneratorClass;
    }

    @Nullable
    public String getAlertID() {
        return this.alertID;
    }

    @Nullable
    public String getAlertMessage() {
        return this.alertMessage;
    }

    @Nullable
    public AlertSeverity getAlertSeverity() {
        return this.alertSeverity;
    }

    @Nullable
    public Date getAlertTime() {
        return this.alertTime;
    }

    @Nullable
    public String getAlertType() {
        return this.alertType;
    }

    @Nullable
    public String getAlertTypeOID() {
        return this.alertTypeOID;
    }
}

