/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.cassandra.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;

class QuotaDTO {
    private final long used;
    private final Optional<Long> limit;

    public static QuotaDTO from(Quota<?, ?> quota) {
        if (quota.getLimit().isUnlimited()) {
            return new QuotaDTO(quota.getUsed().asLong(), Optional.empty());
        }
        return new QuotaDTO(quota.getUsed().asLong(), Optional.of(quota.getLimit().asLong()));
    }

    @JsonCreator
    private QuotaDTO(@JsonProperty(value="used") long used, @JsonProperty(value="limit") Optional<Long> limit) {
        this.used = used;
        this.limit = limit;
    }

    public long getUsed() {
        return this.used;
    }

    public Optional<Long> getLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Quota<QuotaSizeLimit, QuotaSizeUsage> asSizeQuota() {
        return Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)this.used)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size(this.limit)).build();
    }

    @JsonIgnore
    public Quota<QuotaCountLimit, QuotaCountUsage> asCountQuota() {
        return Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)this.used)).computedLimit((QuotaLimitValue)QuotaCountLimit.count(this.limit)).build();
    }
}

