/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetworkMatcher
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNetworkMatcher.class);
    private NetMatcher authorizedNetworks;
    private DNSService dnsServer;

    public void init() throws MessagingException {
        if (this.getCondition() != null) {
            this.authorizedNetworks = new NetMatcher(this.getCondition(), this.dnsServer);
            LOGGER.info("Authorized addresses: {}", (Object)this.authorizedNetworks);
        }
    }

    protected boolean matchNetwork(String addr) {
        return this.authorizedNetworks != null && this.authorizedNetworks.matchInetNetwork(addr);
    }

    @Inject
    public void setDNSService(DNSService dnsService) {
        this.dnsServer = dnsService;
    }
}

