/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.BlobReferenceAggregate;
import org.apache.james.server.blob.deduplication.BloomFilterGCAlgorithm;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import reactor.core.scheduler.Schedulers;

public class BlobGCTask
implements Task {
    public static final TaskType TASK_TYPE = TaskType.of((String)"BlobGCTask");
    private final BlobStoreDAO blobStoreDAO;
    private final GenerationAwareBlobId.Factory generationAwareBlobIdFactory;
    private final GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration;
    private final Set<BlobReferenceSource> blobReferenceSources;
    private final Clock clock;
    private final BucketName bucketName;
    private final int expectedBlobCount;
    private final double associatedProbability;
    private final BloomFilterGCAlgorithm.Context context;

    public static Builder.RequireBlobStoreDAO builder() {
        return blobStoreDao -> generationAwareBlobIdFactory -> generationAwareBlobIdConfiguration -> blobReferenceSources -> bucketName -> clock -> expectedBlobCount -> associatedProbability -> new BlobGCTask(blobStoreDao, generationAwareBlobIdFactory, generationAwareBlobIdConfiguration, blobReferenceSources, bucketName, clock, expectedBlobCount, associatedProbability);
    }

    public BlobGCTask(BlobStoreDAO blobStoreDAO, GenerationAwareBlobId.Factory generationAwareBlobIdFactory, GenerationAwareBlobId.Configuration generationAwareBlobIdConfiguration, Set<BlobReferenceSource> blobReferenceSources, BucketName bucketName, Clock clock, int expectedBlobCount, double associatedProbability) {
        this.blobStoreDAO = blobStoreDAO;
        this.generationAwareBlobIdFactory = generationAwareBlobIdFactory;
        this.generationAwareBlobIdConfiguration = generationAwareBlobIdConfiguration;
        this.blobReferenceSources = blobReferenceSources;
        this.clock = clock;
        this.bucketName = bucketName;
        this.expectedBlobCount = expectedBlobCount;
        this.associatedProbability = associatedProbability;
        this.context = new BloomFilterGCAlgorithm.Context(expectedBlobCount, associatedProbability);
    }

    public Task.Result run() throws InterruptedException {
        BloomFilterGCAlgorithm gcAlgorithm = new BloomFilterGCAlgorithm(BlobReferenceAggregate.aggregate(this.blobReferenceSources), this.blobStoreDAO, this.generationAwareBlobIdFactory, this.generationAwareBlobIdConfiguration, this.clock);
        return (Task.Result)gcAlgorithm.gc(this.expectedBlobCount, this.associatedProbability, this.bucketName, this.context).subscribeOn(Schedulers.elastic()).block();
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.context));
    }

    public Clock getClock() {
        return this.clock;
    }

    public BucketName getBucketName() {
        return this.bucketName;
    }

    public int getExpectedBlobCount() {
        return this.expectedBlobCount;
    }

    public double getAssociatedProbability() {
        return this.associatedProbability;
    }

    static interface Builder {

        @FunctionalInterface
        public static interface RequireBlobStoreDAO {
            public RequireGenerationAwareBlobIdFactory blobStoreDAO(BlobStoreDAO var1);
        }

        @FunctionalInterface
        public static interface RequireGenerationAwareBlobIdFactory {
            public RequireGenerationAwareBlobIdConfiguration generationAwareBlobIdFactory(GenerationAwareBlobId.Factory var1);
        }

        @FunctionalInterface
        public static interface RequireGenerationAwareBlobIdConfiguration {
            public RequireBlobReferenceSources generationAwareBlobIdConfiguration(GenerationAwareBlobId.Configuration var1);
        }

        @FunctionalInterface
        public static interface RequireBlobReferenceSources {
            public RequireBucketName blobReferenceSource(Set<BlobReferenceSource> var1);
        }

        @FunctionalInterface
        public static interface RequireBucketName {
            public RequireClock bucketName(BucketName var1);
        }

        @FunctionalInterface
        public static interface RequireClock {
            public RequireExpectedBlobCount clock(Clock var1);
        }

        @FunctionalInterface
        public static interface RequireExpectedBlobCount {
            public RequireAssociatedProbability expectedBlobCount(int var1);
        }

        @FunctionalInterface
        public static interface RequireAssociatedProbability {
            public BlobGCTask associatedProbability(double var1);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final long referenceSourceCount;
        private final long blobCount;
        private final long gcedBlobCount;
        private final long errorCount;
        private final long bloomFilterExpectedBlobCount;
        private final double bloomFilterAssociatedProbability;

        private static AdditionalInformation from(BloomFilterGCAlgorithm.Context context) {
            BloomFilterGCAlgorithm.Context.Snapshot snapshot = context.snapshot();
            return new AdditionalInformation(snapshot.getReferenceSourceCount(), snapshot.getBlobCount(), snapshot.getGcedBlobCount(), snapshot.getErrorCount(), snapshot.getBloomFilterExpectedBlobCount(), snapshot.getBloomFilterAssociatedProbability(), Clock.systemUTC().instant());
        }

        AdditionalInformation(long referenceSourceCount, long blobCount, long gcedBlobCount, long errorCount, long bloomFilterExpectedBlobCount, double bloomFilterAssociatedProbability, Instant timestamp) {
            this.referenceSourceCount = referenceSourceCount;
            this.blobCount = blobCount;
            this.gcedBlobCount = gcedBlobCount;
            this.errorCount = errorCount;
            this.bloomFilterExpectedBlobCount = bloomFilterExpectedBlobCount;
            this.bloomFilterAssociatedProbability = bloomFilterAssociatedProbability;
            this.timestamp = timestamp;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public long getReferenceSourceCount() {
            return this.referenceSourceCount;
        }

        public long getBlobCount() {
            return this.blobCount;
        }

        public long getGcedBlobCount() {
            return this.gcedBlobCount;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getBloomFilterExpectedBlobCount() {
            return this.bloomFilterExpectedBlobCount;
        }

        public double getBloomFilterAssociatedProbability() {
            return this.bloomFilterAssociatedProbability;
        }
    }
}

